/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.HostServerAdd;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.UpdateFailedException;

public final class HostServerRemove
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final String serverName;

    public HostServerRemove(String serverName) {
        this.serverName = serverName;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (!element.removeServer(this.serverName)) {
            throw new UpdateFailedException("Server " + this.serverName + " was not configured");
        }
    }

    public HostServerAdd getCompensatingUpdate(HostModel original) {
        ServerElement se = original.getServer(this.serverName);
        if (se != null) {
            return new HostServerAdd(se.getName(), se.getServerGroup());
        }
        return null;
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

