/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.UpdateFailedException;

public class HostServerUpdate<R>
extends AbstractHostModelUpdate<R> {
    private static final long serialVersionUID = 1656392748485415899L;
    private final String serverName;
    private final AbstractModelUpdate<ServerElement, R> serverUpdate;

    public HostServerUpdate(String serverName, AbstractModelUpdate<ServerElement, R> serverUpdate) {
        this.serverName = serverName;
        this.serverUpdate = serverUpdate;
    }

    public static <T> HostServerUpdate<T> create(String serverName, AbstractModelUpdate<ServerElement, T> serverUpdate) {
        return new HostServerUpdate<T>(serverName, serverUpdate);
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        ServerElement server = element.getServer(this.serverName);
        if (server == null) {
            throw new UpdateFailedException(String.format("server (%s) does not exist", this.serverName));
        }
        this.serverUpdate.applyUpdate(server);
    }

    @Override
    public HostServerUpdate<?> getCompensatingUpdate(HostModel original) {
        ServerElement server = original.getServer(this.serverName);
        if (server == null) {
            return null;
        }
        return HostServerUpdate.create(this.serverName, this.serverUpdate.getCompensatingUpdate((AbstractModelElement)server));
    }

    @Override
    public AbstractServerModelUpdate<R> getServerModelUpdate() {
        return this.serverUpdate.getServerModelUpdate();
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        if (this.getServerModelUpdate() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.serverName);
    }
}

