/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.Extension;
import org.jboss.as.ExtensionContext;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.DomainDeploymentAdd;
import org.jboss.as.model.DomainExtensionAdd;
import org.jboss.as.model.DomainInterfaceAdd;
import org.jboss.as.model.DomainNamespaceUpdate;
import org.jboss.as.model.DomainPathAdd;
import org.jboss.as.model.DomainProfileAdd;
import org.jboss.as.model.DomainProfileIncludeAdd;
import org.jboss.as.model.DomainSchemaLocationUpdate;
import org.jboss.as.model.DomainServerGroupAdd;
import org.jboss.as.model.DomainServerGroupUpdate;
import org.jboss.as.model.DomainSocketBindingGroupAdd;
import org.jboss.as.model.DomainSocketBindingUpdate;
import org.jboss.as.model.DomainSubsystemAdd;
import org.jboss.as.model.DomainSubsystemUpdate;
import org.jboss.as.model.DomainSystemPropertyUpdate;
import org.jboss.as.model.Element;
import org.jboss.as.model.HostExtensionAdd;
import org.jboss.as.model.HostInterfaceAdd;
import org.jboss.as.model.HostJvmAdd;
import org.jboss.as.model.HostJvmUpdate;
import org.jboss.as.model.HostLocalDomainControllerAdd;
import org.jboss.as.model.HostManagementSocketAdd;
import org.jboss.as.model.HostManagementSocketThreadsUpdate;
import org.jboss.as.model.HostNameUpdate;
import org.jboss.as.model.HostNamespaceUpdate;
import org.jboss.as.model.HostPathAdd;
import org.jboss.as.model.HostRemoteDomainControllerAdd;
import org.jboss.as.model.HostSchemaLocationUpdate;
import org.jboss.as.model.HostServerAdd;
import org.jboss.as.model.HostServerUpdate;
import org.jboss.as.model.HostSystemPropertyUpdate;
import org.jboss.as.model.JvmAgentLibUpdate;
import org.jboss.as.model.JvmAgentPathUpdate;
import org.jboss.as.model.JvmDebugEnabledUpdate;
import org.jboss.as.model.JvmDebugOptionsUpdate;
import org.jboss.as.model.JvmElement;
import org.jboss.as.model.JvmEnvClasspathIgnoredUpdate;
import org.jboss.as.model.JvmEnvironmentVariableUpdate;
import org.jboss.as.model.JvmHeapUpdate;
import org.jboss.as.model.JvmHomeUpdate;
import org.jboss.as.model.JvmJavaagentUpdate;
import org.jboss.as.model.JvmMaxHeapUpdate;
import org.jboss.as.model.JvmMaxPermgenUpdate;
import org.jboss.as.model.JvmOptionAdd;
import org.jboss.as.model.JvmOptionsUpdate;
import org.jboss.as.model.JvmPermgenUpdate;
import org.jboss.as.model.JvmStackUpdate;
import org.jboss.as.model.JvmSystemPropertiesUpdate;
import org.jboss.as.model.JvmType;
import org.jboss.as.model.JvmTypeUpdate;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.NamespacePrefix;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.PropertyAdd;
import org.jboss.as.model.SchemaLocation;
import org.jboss.as.model.ServerDeploymentRepositoryAdd;
import org.jboss.as.model.ServerElementInterfaceAdd;
import org.jboss.as.model.ServerElementJvmAdd;
import org.jboss.as.model.ServerElementJvmUpdate;
import org.jboss.as.model.ServerElementPathAdd;
import org.jboss.as.model.ServerElementSocketBindingGroupUpdate;
import org.jboss.as.model.ServerElementSocketBindingPortOffsetUpdate;
import org.jboss.as.model.ServerElementStartStopUpdate;
import org.jboss.as.model.ServerElementSystemPropertyUpdate;
import org.jboss.as.model.ServerExtensionAdd;
import org.jboss.as.model.ServerGroupDeploymentAdd;
import org.jboss.as.model.ServerGroupJvmAdd;
import org.jboss.as.model.ServerGroupJvmUpdate;
import org.jboss.as.model.ServerGroupPropertiesUpdate;
import org.jboss.as.model.ServerGroupSocketBindingGroupUpdate;
import org.jboss.as.model.ServerGroupSocketBindingPortOffsetUpdate;
import org.jboss.as.model.ServerModelDeploymentAdd;
import org.jboss.as.model.ServerModelDeploymentStartStopUpdate;
import org.jboss.as.model.ServerModelInterfaceAdd;
import org.jboss.as.model.ServerModelManagementSocketAdd;
import org.jboss.as.model.ServerModelManagementSocketThreadsUpdate;
import org.jboss.as.model.ServerNameUpdate;
import org.jboss.as.model.ServerNamespaceUpdate;
import org.jboss.as.model.ServerPathAdd;
import org.jboss.as.model.ServerProfileUpdate;
import org.jboss.as.model.ServerSchemaLocationUpdate;
import org.jboss.as.model.ServerSocketBindingGroupUpdate;
import org.jboss.as.model.ServerSocketBindingUpdate;
import org.jboss.as.model.ServerSubsystemAdd;
import org.jboss.as.model.ServerSubsystemUpdate;
import org.jboss.as.model.ServerSystemPropertyUpdate;
import org.jboss.as.model.socket.CompoundCriteriaElement;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceParsingUtils;
import org.jboss.as.model.socket.SocketBindingAdd;
import org.jboss.as.model.socket.SocketBindingGroupUpdate;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;

public final class ModelXmlParsers {
    public static final XMLElementReader<List<? super AbstractDomainModelUpdate<?>>> DOMAIN_XML_READER = new XMLElementReader<List<? super AbstractDomainModelUpdate<?>>>(){

        public void readElement(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> objects) throws XMLStreamException {
            ModelXmlParsers.parseDomainRootElement(reader, objects);
        }
    };
    public static final XMLElementReader<List<? super AbstractHostModelUpdate<?>>> HOST_XML_READER = new XMLElementReader<List<? super AbstractHostModelUpdate<?>>>(){

        public void readElement(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> objects) throws XMLStreamException {
            ModelXmlParsers.parseHostRootElement(reader, objects);
        }
    };
    public static final XMLElementReader<List<? super AbstractServerModelUpdate<?>>> SERVER_XML_READER = new XMLElementReader<List<? super AbstractServerModelUpdate<?>>>(){

        public void readElement(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> objects) throws XMLStreamException {
            ModelXmlParsers.parseServerRootElement(reader, objects);
        }
    };

    private ModelXmlParsers() {
    }

    public static void registerAll(XMLMapper xmlMapper) {
        xmlMapper.registerRootElement(new QName(Namespace.DOMAIN_1_0.getUriString(), Element.DOMAIN.getLocalName()), DOMAIN_XML_READER);
        xmlMapper.registerRootElement(new QName(Namespace.DOMAIN_1_0.getUriString(), Element.HOST.getLocalName()), HOST_XML_READER);
        xmlMapper.registerRootElement(new QName(Namespace.DOMAIN_1_0.getUriString(), Element.SERVER.getLocalName()), SERVER_XML_READER);
    }

    public static void parseServerRootElement(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> list) throws XMLStreamException {
        Element element;
        List<NamespacePrefix> prefixes = ParseUtils.readNamespaces(reader);
        if (!prefixes.isEmpty()) {
            list.add(new ServerNamespaceUpdate(prefixes));
        }
        String serverName = null;
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri(reader.getAttributeNamespace(i))) {
                case DOMAIN_1_0: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            if (serverName != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            serverName = value;
                            continue block22;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            List<SchemaLocation> locationList = ParseUtils.readSchemaLocations(reader, i);
                            list.add(new ServerSchemaLocationUpdate(locationList));
                            continue block22;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block22;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case UNKNOWN: {
                    if (reader.getAttributeNamespace(i) != null) {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            if (serverName != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            serverName = value;
                            continue block22;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (serverName != null && serverName.length() != 0) {
            list.add(new ServerNameUpdate(serverName));
        }
        if ((element = ModelXmlParsers.nextElement(reader)) == Element.EXTENSIONS) {
            Set<String> extensionModules = ModelXmlParsers.parseExtensions(reader);
            for (String moduleName : extensionModules) {
                list.add(new ServerExtensionAdd(moduleName));
            }
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.PATHS) {
            ModelXmlParsers.parseServerModelPaths(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.MANAGEMENT) {
            ModelXmlParsers.parseServerManagement(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.PROFILE) {
            ModelXmlParsers.parseServerProfile(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        Set<String> interfaceNames = null;
        if (element == Element.INTERFACES) {
            interfaceNames = ModelXmlParsers.parseServerModelInterfaces(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            ArrayList<SocketBindingAdd> bindingUpdates = new ArrayList<SocketBindingAdd>();
            SocketBindingGroupUpdate group = ModelXmlParsers.parseSocketBindingGroup(reader, bindingUpdates, interfaceNames, false);
            list.add(new ServerSocketBindingGroupUpdate(group));
            for (SocketBindingAdd bindingUpdate : bindingUpdates) {
                list.add(new ServerSocketBindingUpdate(bindingUpdate));
            }
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            ModelXmlParsers.parseServerModelSystemProperties(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.DEPLOYMENT_REPOSITORY) {
            boolean enabled = true;
            int interval = 0;
            String path = null;
            String name = null;
            String relativeTo = null;
            int attrCount = reader.getAttributeCount();
            block25: for (int i = 0; i < attrCount; ++i) {
                String value = reader.getAttributeValue(i);
                if (reader.getAttributeNamespace(i) != null) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case PATH: {
                        path = value;
                        continue block25;
                    }
                    case NAME: {
                        name = value;
                        continue block25;
                    }
                    case RELATIVE_TO: {
                        relativeTo = value;
                        continue block25;
                    }
                    case SCAN_INTERVAL: {
                        interval = Integer.parseInt(value);
                        continue block25;
                    }
                    case SCAN_ENABLED: {
                        enabled = Boolean.parseBoolean(value);
                        continue block25;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (path == null) {
                ParseUtils.missingRequired(reader, Collections.singleton("path"));
            }
            ParseUtils.requireNoContent(reader);
            ServerDeploymentRepositoryAdd action = new ServerDeploymentRepositoryAdd(path, interval, enabled);
            action.setName(name);
            action.setRelativeTo(relativeTo);
            list.add(action);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.DEPLOYMENTS) {
            ModelXmlParsers.parseServerDeployments(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static void parseHostRootElement(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        Element element;
        List<NamespacePrefix> prefixes = ParseUtils.readNamespaces(reader);
        if (!prefixes.isEmpty()) {
            list.add(new HostNamespaceUpdate(prefixes));
        }
        String name = null;
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri(reader.getAttributeNamespace(i))) {
                case DOMAIN_1_0: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            if (name != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            name = value;
                            continue block15;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            List<SchemaLocation> locationList = ParseUtils.readSchemaLocations(reader, i);
                            list.add(new HostSchemaLocationUpdate(locationList));
                            continue block15;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block15;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case UNKNOWN: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            if (name != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            name = value;
                            continue block15;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name != null && name.length() != 0) {
            list.add(new HostNameUpdate(name));
        }
        if ((element = ModelXmlParsers.nextElement(reader)) == Element.EXTENSIONS) {
            Set<String> extensionModules = ModelXmlParsers.parseExtensions(reader);
            for (String moduleName : extensionModules) {
                list.add(new HostExtensionAdd(moduleName));
            }
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.PATHS) {
            ModelXmlParsers.parseHostPaths(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            ModelXmlParsers.parseHostSystemProperties(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.MANAGEMENT) {
            ModelXmlParsers.parseManagement(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.DOMAIN_CONTROLLER) {
            ModelXmlParsers.parseDomainController(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.INTERFACES) {
            ModelXmlParsers.parseHostInterfaces(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.JVMS) {
            ModelXmlParsers.parseJvms(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.SERVERS) {
            ModelXmlParsers.parseServers(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
    }

    public static void parseDomainRootElement(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list) throws XMLStreamException {
        List<NamespacePrefix> prefixes = ParseUtils.readNamespaces(reader);
        if (!prefixes.isEmpty()) {
            list.add(new DomainNamespaceUpdate(prefixes));
        }
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri(reader.getAttributeNamespace(i))) {
                case DOMAIN_1_0: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName(reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            List<SchemaLocation> locationList = ParseUtils.readSchemaLocations(reader, i);
                            list.add(new DomainSchemaLocationUpdate(locationList));
                            continue block8;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block8;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        Element element = ModelXmlParsers.nextElement(reader);
        if (element == Element.EXTENSIONS) {
            Set<String> extensionModules = ModelXmlParsers.parseExtensions(reader);
            for (String moduleName : extensionModules) {
                list.add(new DomainExtensionAdd(moduleName));
            }
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.PATHS) {
            ModelXmlParsers.parseDomainPaths(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.PROFILES) {
            ModelXmlParsers.parseProfiles(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        Set<String> interfaceNames = Collections.emptySet();
        if (element == Element.INTERFACES) {
            interfaceNames = ModelXmlParsers.parseDomainInterfaces(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.SOCKET_BINDING_GROUPS) {
            ModelXmlParsers.parseDomainSocketBindingGroups(reader, list, interfaceNames);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            ModelXmlParsers.parseDomainSystemProperties(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.DEPLOYMENTS) {
            ModelXmlParsers.parseDeployments(reader, list, null);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element == Element.SERVER_GROUPS) {
            ModelXmlParsers.parseServerGroups(reader, list);
            element = ModelXmlParsers.nextElement(reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    static Set<String> parseExtensions(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        ExtensionContextImpl extensionContext = new ExtensionContextImpl(reader);
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        while (reader.nextTag() != 2) {
            String moduleName = ParseUtils.readStringAttributeElement(reader, Attribute.MODULE.getLocalName());
            if (!found.add(moduleName)) {
                throw ParseUtils.invalidAttributeValue(reader, 0);
            }
            try {
                Module module = Module.getModuleFromDefaultLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)moduleName));
                for (Extension extension : module.loadService(Extension.class)) {
                    extension.initialize(extensionContext);
                }
            }
            catch (ModuleLoadException e) {
                throw new XMLStreamException("Failed to load module", e);
            }
        }
        return found;
    }

    static void parseProfiles(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw new XMLStreamException("Duplicate profile declaration " + name, reader.getLocation());
            }
            list.add(new DomainProfileAdd(name));
            LinkedHashSet<String> includes = new LinkedHashSet<String>();
            HashSet<String> configuredSubsystemTypes = new HashSet<String>();
            block5: while (reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case UNKNOWN: {
                        if (Element.forName(reader.getLocalName()) != Element.SUBSYSTEM) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        if (!configuredSubsystemTypes.add(reader.getNamespaceURI())) {
                            throw new XMLStreamException("Duplicate subsystem declaration", reader.getLocation());
                        }
                        ParseResult result = new ParseResult();
                        reader.handleAny(result);
                        list.add(new DomainSubsystemAdd(name, ((ExtensionContext.SubsystemConfiguration)result.getResult()).getSubsystemAdd()));
                        for (AbstractSubsystemUpdate update : ((ExtensionContext.SubsystemConfiguration)result.getResult()).getUpdates()) {
                            list.add(DomainSubsystemUpdate.create(name, update));
                        }
                        continue block5;
                    }
                    case DOMAIN_1_0: {
                        if (configuredSubsystemTypes.size() > 0) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        if (Element.forName(reader.getLocalName()) != Element.INCLUDE) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        String includedName = ParseUtils.readStringAttributeElement(reader, Attribute.PROFILE.getLocalName());
                        if (!names.contains(includedName)) {
                            throw new XMLStreamException("No profile found for inclusion", reader.getLocation());
                        }
                        if (!includes.add(includedName)) {
                            throw new XMLStreamException("Duplicate profile include", reader.getLocation());
                        }
                        list.add(new DomainProfileIncludeAdd(name, includedName));
                        continue block5;
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
            if (configuredSubsystemTypes.size() != 0) continue;
            throw new XMLStreamException("Profile has no subsystem configurations", reader.getLocation());
        }
    }

    static void parseServerProfile(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String name = reader.getAttributeValue(0);
        list.add(new ServerProfileUpdate(name));
        HashSet<String> configuredSubsystemTypes = new HashSet<String>();
        block3: while (reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case UNKNOWN: {
                    if (Element.forName(reader.getLocalName()) != Element.SUBSYSTEM) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    if (!configuredSubsystemTypes.add(reader.getNamespaceURI())) {
                        throw new XMLStreamException("Duplicate subsystem declaration", reader.getLocation());
                    }
                    ParseResult result = new ParseResult();
                    reader.handleAny(result);
                    list.add(new ServerSubsystemAdd(((ExtensionContext.SubsystemConfiguration)result.getResult()).getSubsystemAdd()));
                    for (AbstractSubsystemUpdate update : ((ExtensionContext.SubsystemConfiguration)result.getResult()).getUpdates()) {
                        list.add(ServerSubsystemUpdate.create(update));
                    }
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (configuredSubsystemTypes.size() == 0) {
            throw new XMLStreamException("Profile has no subsystem configurations", reader.getLocation());
        }
    }

    static Set<String> parseHostInterfaces(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        ArrayList<InterfaceAdd> updates = new ArrayList<InterfaceAdd>();
        HashSet<String> names = new HashSet<String>();
        ModelXmlParsers.parseInterfaces(reader, names, updates, true);
        for (InterfaceAdd update : updates) {
            list.add(new HostInterfaceAdd(update));
        }
        return names;
    }

    static Set<String> parseServerElementInterfaces(String serverName, XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        ArrayList<InterfaceAdd> updates = new ArrayList<InterfaceAdd>();
        HashSet<String> names = new HashSet<String>();
        ModelXmlParsers.parseInterfaces(reader, names, updates, true);
        for (InterfaceAdd update : updates) {
            list.add(HostServerUpdate.create(serverName, new ServerElementInterfaceAdd(update)));
        }
        return names;
    }

    static Set<String> parseServerModelInterfaces(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> list) throws XMLStreamException {
        ArrayList<InterfaceAdd> updates = new ArrayList<InterfaceAdd>();
        HashSet<String> names = new HashSet<String>();
        ModelXmlParsers.parseInterfaces(reader, names, updates, true);
        for (InterfaceAdd update : updates) {
            list.add(new ServerModelInterfaceAdd(update));
        }
        return names;
    }

    static Set<String> parseDomainInterfaces(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list) throws XMLStreamException {
        ArrayList<InterfaceAdd> updates = new ArrayList<InterfaceAdd>();
        HashSet<String> names = new HashSet<String>();
        ModelXmlParsers.parseInterfaces(reader, names, updates, false);
        for (InterfaceAdd update : updates) {
            list.add(new DomainInterfaceAdd(update));
        }
        return names;
    }

    static Set<String> parseInterfaces(XMLExtendedStreamReader reader, Set<String> names, List<InterfaceAdd> list, boolean checkSpecified) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        while (reader.nextTag() != 2) {
            ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
            String name = reader.getAttributeValue(0);
            if (!names.add(name)) {
                throw new XMLStreamException("Duplicate interface declaration", reader.getLocation());
            }
            if (reader.nextTag() == 2) {
                if (!checkSpecified) continue;
                throw ParseUtils.unexpectedEndElement(reader);
            }
            HashMap<Element, CompoundCriteriaElement> interfaceCriteria = new HashMap<Element, CompoundCriteriaElement>();
            boolean first = true;
            Element anyElement = null;
            do {
                if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
                    throw ParseUtils.unexpectedElement(reader);
                }
                Element element = Element.forName(reader.getLocalName());
                block0 : switch (element) {
                    case ANY_ADDRESS: 
                    case ANY_IPV4_ADDRESS: 
                    case ANY_IPV6_ADDRESS: {
                        if (!first || anyElement != null) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        ParseUtils.requireNoAttributes(reader);
                        ParseUtils.requireNoContent(reader);
                        anyElement = element;
                        break;
                    }
                    default: {
                        CompoundCriteriaElement criteria;
                        if (anyElement != null) {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                        switch (element) {
                            case ANY: 
                            case NOT: {
                                criteria = InterfaceParsingUtils.createCompoundCriteria(reader, element == Element.ANY);
                                interfaceCriteria.put(element, criteria);
                                break block0;
                            }
                        }
                        criteria = InterfaceParsingUtils.parseSimpleInterfaceCriteria(reader, element);
                        interfaceCriteria.put(element, criteria);
                    }
                }
                first = false;
            } while (reader.nextTag() != 2);
            if (checkSpecified && anyElement == null && interfaceCriteria.isEmpty()) {
                throw new XMLStreamException("Either an inet-address element or some other interface criteria element is required", reader.getLocation());
            }
            list.add(new InterfaceAdd(name, anyElement == Element.ANY_IPV4_ADDRESS, anyElement == Element.ANY_IPV6_ADDRESS, anyElement == Element.ANY_ADDRESS, interfaceCriteria.values()));
        }
        return names;
    }

    static void parseDomainSocketBindingGroups(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list, Set<String> interfaces) throws XMLStreamException {
        HashSet<String> groupNames = new HashSet<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SOCKET_BINDING_GROUP: {
                            ArrayList<SocketBindingAdd> bindingUpdates = new ArrayList<SocketBindingAdd>();
                            SocketBindingGroupUpdate group = ModelXmlParsers.parseSocketBindingGroup(reader, bindingUpdates, interfaces, true);
                            String name = group.getName();
                            if (groupNames.add(name)) {
                                ParseUtils.unexpectedElement(reader);
                            }
                            list.add(new DomainSocketBindingGroupAdd(group));
                            for (SocketBindingAdd bindingUpdate : bindingUpdates) {
                                list.add(new DomainSocketBindingUpdate(name, bindingUpdate));
                            }
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    static SocketBindingGroupUpdate parseSocketBindingGroup(XMLExtendedStreamReader reader, List<SocketBindingAdd> bindingUpdates, Set<String> interfaces, boolean allowInclude) throws XMLStreamException {
        String name = null;
        String defIntf = null;
        HashSet<String> includedGroups = new HashSet<String>();
        HashSet<String> socketBindings = new HashSet<String>();
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case DEFAULT_INTERFACE: {
                    if (!interfaces.contains(value)) {
                        throw new XMLStreamException("Unknown interface " + value + " " + attribute.getLocalName() + " must be declared in element " + Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    defIntf = value;
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (defIntf == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.DEFAULT_INTERFACE));
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case INCLUDE: {
                            if (!allowInclude) {
                                throw ParseUtils.unexpectedElement(reader);
                            }
                            String includedGroup = ParseUtils.readStringAttributeElement(reader, Attribute.SOCKET_BINDING_GROUP.getLocalName());
                            if (includedGroups.contains(includedGroup)) {
                                throw new XMLStreamException("Included socket-binding-group " + includedGroup + " already declared", reader.getLocation());
                            }
                            includedGroups.add(includedGroup);
                            continue block12;
                        }
                        case SOCKET_BINDING: {
                            String bindingName = ModelXmlParsers.parseSocketBinding(reader, interfaces, bindingUpdates, defIntf);
                            if (socketBindings.contains(bindingName)) {
                                throw new XMLStreamException("socket-binding " + bindingName + " already declared", reader.getLocation());
                            }
                            socketBindings.add(bindingName);
                            continue block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return new SocketBindingGroupUpdate(name, defIntf, includedGroups);
    }

    static String parseSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, List<SocketBindingAdd> updates, String inheritedInterfaceName) throws XMLStreamException {
        String name = null;
        String interfaceName = null;
        Integer port = null;
        Boolean fixPort = null;
        InetAddress mcastAddr = null;
        Integer mcastPort = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case INTERFACE: {
                    if (!interfaces.contains(value)) {
                        throw new XMLStreamException("Unknown interface " + value + " " + attribute.getLocalName() + " must be declared in element " + Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    interfaceName = value;
                    continue block10;
                }
                case PORT: {
                    port = ModelXmlParsers.parsePort(value, attribute, reader, true);
                    continue block10;
                }
                case FIXED_PORT: {
                    fixPort = Boolean.valueOf(value);
                    continue block10;
                }
                case MULTICAST_ADDRESS: {
                    try {
                        mcastAddr = InetAddress.getByName(value);
                        if (!mcastAddr.isMulticastAddress()) {
                            throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " is not a valid multicast address", reader.getLocation());
                        }
                    }
                    catch (UnknownHostException e) {
                        throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " is not a valid multicast address", reader.getLocation(), e);
                    }
                }
                case MULTICAST_PORT: {
                    mcastPort = ModelXmlParsers.parsePort(value, attribute, reader, false);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent(reader);
        SocketBindingAdd update = new SocketBindingAdd(interfaceName == null ? inheritedInterfaceName : interfaceName, name, port == null ? 0 : port);
        update.setFixedPort(fixPort == null ? false : fixPort);
        update.setMulticastAddress(mcastAddr);
        update.setMulticastPort(mcastAddr == null ? -1 : (mcastPort != null ? mcastPort : -1));
        updates.add(update);
        return name;
    }

    static void parseDeployments(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list, String serverGroupName) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            String uniqueName = null;
            String runtimeName = null;
            byte[] hash = null;
            String startInput = null;
            int count = reader.getAttributeCount();
            block10: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (reader.getAttributeNamespace(i) != null) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement(reader, value);
                        }
                        uniqueName = value;
                        continue block10;
                    }
                    case RUNTIME_NAME: {
                        runtimeName = value;
                        continue block10;
                    }
                    case SHA1: {
                        try {
                            hash = ParseUtils.hexStringToByteArray(value);
                            continue block10;
                        }
                        catch (Exception e) {
                            throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " does not represent a properly hex-encoded SHA1 hash", reader.getLocation(), e);
                        }
                    }
                    case ALLOWED: {
                        if (Boolean.parseBoolean(value)) continue block10;
                        throw new XMLStreamException("Attribute '" + attribute.getLocalName() + "' is not allowed", reader.getLocation());
                    }
                    case START: {
                        startInput = value;
                        continue block10;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (uniqueName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
            }
            if (runtimeName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.RUNTIME_NAME));
            }
            if (hash == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SHA1));
            }
            boolean toStart = startInput == null ? true : Boolean.parseBoolean(startInput);
            ParseUtils.requireNoContent(reader);
            if (serverGroupName == null) {
                list.add(new DomainDeploymentAdd(uniqueName, runtimeName, hash, toStart));
                continue;
            }
            list.add(DomainServerGroupUpdate.create(serverGroupName, new ServerGroupDeploymentAdd(uniqueName, runtimeName, hash, toStart)));
        }
    }

    static void parseServerDeployments(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            String uniqueName = null;
            String runtimeName = null;
            byte[] hash = null;
            String startInput = null;
            int count = reader.getAttributeCount();
            block10: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (reader.getAttributeNamespace(i) != null) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement(reader, value);
                        }
                        uniqueName = value;
                        continue block10;
                    }
                    case RUNTIME_NAME: {
                        runtimeName = value;
                        continue block10;
                    }
                    case SHA1: {
                        try {
                            hash = ParseUtils.hexStringToByteArray(value);
                            continue block10;
                        }
                        catch (Exception e) {
                            throw new XMLStreamException("Value " + value + " for attribute " + attribute.getLocalName() + " does not represent a properly hex-encoded SHA1 hash", reader.getLocation(), e);
                        }
                    }
                    case ALLOWED: {
                        if (Boolean.parseBoolean(value)) continue block10;
                        throw new XMLStreamException("Attribute '" + attribute.getLocalName() + "' is not allowed", reader.getLocation());
                    }
                    case START: {
                        startInput = value;
                        continue block10;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (uniqueName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
            }
            if (runtimeName == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.RUNTIME_NAME));
            }
            if (hash == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SHA1));
            }
            boolean toStart = startInput == null ? true : Boolean.parseBoolean(startInput);
            ParseUtils.requireNoContent(reader);
            list.add(new ServerModelDeploymentAdd(uniqueName, runtimeName, hash));
            list.add(new ServerModelDeploymentStartStopUpdate(uniqueName, toStart));
        }
    }

    static void parseServerGroups(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        while (reader.nextTag() != 2) {
            String name = null;
            String profile = null;
            Collection<PropertyAdd> systemProperties = null;
            int count = reader.getAttributeCount();
            block14: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (reader.getAttributeNamespace(i) != null) {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        if (name != null) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement(reader, value);
                        }
                        name = value;
                        continue block14;
                    }
                    case PROFILE: {
                        if (profile != null) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        profile = value;
                        continue block14;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
            }
            if (profile == null) {
                throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PROFILE));
            }
            list.add(new DomainServerGroupAdd(name, profile));
            NamedModelUpdates<JvmElement> jvm = null;
            NameOffset socketBinding = null;
            boolean sawDeployments = false;
            block15: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case DOMAIN_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case JVM: {
                                if (jvm != null) {
                                    throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                                }
                                jvm = ModelXmlParsers.parseJvm(reader);
                                list.add(DomainServerGroupUpdate.create(name, new ServerGroupJvmAdd(jvm.name)));
                                for (AbstractModelUpdate abstractModelUpdate : jvm.updates) {
                                    list.add(DomainServerGroupUpdate.create(name, ServerGroupJvmUpdate.create(abstractModelUpdate)));
                                }
                                continue block15;
                            }
                            case SOCKET_BINDING_GROUP: {
                                if (socketBinding != null) {
                                    throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                                }
                                socketBinding = ModelXmlParsers.parseSocketBindingGroupRef(reader);
                                list.add(DomainServerGroupUpdate.create(name, new ServerGroupSocketBindingGroupUpdate(socketBinding.name)));
                                if (socketBinding.offset <= 0) continue block15;
                                list.add(DomainServerGroupUpdate.create(name, new ServerGroupSocketBindingPortOffsetUpdate(socketBinding.offset)));
                                continue block15;
                            }
                            case DEPLOYMENTS: {
                                if (sawDeployments) {
                                    throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                                }
                                sawDeployments = true;
                                ModelXmlParsers.parseDeployments(reader, list, name);
                                continue block15;
                            }
                            case SYSTEM_PROPERTIES: {
                                if (systemProperties != null) {
                                    throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                                }
                                systemProperties = ModelXmlParsers.parseProperties(reader, Element.PROPERTY, true);
                                for (PropertyAdd propertyAdd : systemProperties) {
                                    list.add(DomainServerGroupUpdate.create(name, new ServerGroupPropertiesUpdate(name, propertyAdd)));
                                }
                                continue block15;
                            }
                        }
                        throw ParseUtils.unexpectedElement(reader);
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    static void parseDomainSystemProperties(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list) throws XMLStreamException {
        for (PropertyAdd propertyUpdate : ModelXmlParsers.parseProperties(reader, Element.PROPERTY, true)) {
            list.add(new DomainSystemPropertyUpdate(propertyUpdate));
        }
    }

    static void parseHostSystemProperties(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        for (PropertyAdd propertyUpdate : ModelXmlParsers.parseProperties(reader, Element.PROPERTY, true)) {
            list.add(new HostSystemPropertyUpdate(propertyUpdate));
        }
    }

    static void parseServerModelSystemProperties(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> list) throws XMLStreamException {
        for (PropertyAdd propertyUpdate : ModelXmlParsers.parseProperties(reader, Element.PROPERTY, true)) {
            list.add(new ServerSystemPropertyUpdate(propertyUpdate));
        }
    }

    static Collection<PropertyAdd> parseProperties(XMLExtendedStreamReader reader, Element propertyType, boolean allowNullValue) throws XMLStreamException {
        HashMap<String, PropertyAdd> properties = new HashMap<String, PropertyAdd>();
        ParseUtils.requireNoAttributes(reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == propertyType) {
                        String name = null;
                        String value = null;
                        int count = reader.getAttributeCount();
                        block8: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (reader.getAttributeNamespace(i) != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    if (!properties.containsKey(name)) continue block8;
                                    throw new XMLStreamException("Property " + name + " already exists", reader.getLocation());
                                }
                                case VALUE: {
                                    value = attrValue;
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute(reader, i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
                        }
                        if (value == null && !allowNullValue) {
                            throw new XMLStreamException("Value for property " + name + " is null", reader.getLocation());
                        }
                        properties.put(name, new PropertyAdd(name, value));
                        ParseUtils.requireNoContent(reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (properties.size() == 0) {
            throw ParseUtils.missingRequiredElement(reader, Collections.singleton(propertyType));
        }
        return properties.values();
    }

    static void parseJvms(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case JVM: {
                            NamedModelUpdates<JvmElement> jvm = ModelXmlParsers.parseJvm(reader, names);
                            list.add(new HostJvmAdd(jvm.name));
                            for (AbstractModelUpdate update : jvm.updates) {
                                list.add(HostJvmUpdate.create(jvm.name, update));
                            }
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedElement(reader);
                        }
                    }
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    static NamedModelUpdates<JvmElement> parseJvm(XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> empty = new HashSet<String>();
        return ModelXmlParsers.parseJvm(reader, empty);
    }

    static NamedModelUpdates<JvmElement> parseJvm(XMLExtendedStreamReader reader, Set<String> jvmNames) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        String name = null;
        String type = null;
        String home = null;
        Boolean debugEnabled = null;
        String debugOptions = null;
        Boolean envClasspathIgnored = null;
        int count = reader.getAttributeCount();
        block24: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    if (!jvmNames.add(value)) {
                        throw new XMLStreamException("Duplicate JVM declaration " + value, reader.getLocation());
                    }
                    name = value;
                    continue block24;
                }
                case JAVA_HOME: {
                    if (home != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    home = value;
                    updates.add(new JvmHomeUpdate(value));
                    continue block24;
                }
                case TYPE: {
                    JvmType jvmType;
                    if (type != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    type = value;
                    try {
                        jvmType = Enum.valueOf(JvmType.class, value);
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue(reader, i);
                    }
                    updates.add(new JvmTypeUpdate(jvmType));
                    continue block24;
                }
                case DEBUG_ENABLED: {
                    if (debugEnabled != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    debugEnabled = Boolean.valueOf(value);
                    updates.add(new JvmDebugEnabledUpdate(debugEnabled));
                    continue block24;
                }
                case DEBUG_OPTIONS: {
                    if (debugOptions != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    debugOptions = value;
                    updates.add(new JvmDebugOptionsUpdate(value));
                    continue block24;
                }
                case ENV_CLASSPATH_IGNORED: {
                    if (envClasspathIgnored != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    envClasspathIgnored = Boolean.valueOf(value);
                    updates.add(new JvmEnvClasspathIgnoredUpdate(envClasspathIgnored));
                    continue block24;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (type == null) {
            updates.add(new JvmTypeUpdate(JvmType.SUN));
        }
        Collection<JvmOptionAdd> jvmOptions = null;
        Collection<PropertyAdd> environmentVariables = null;
        Collection<PropertyAdd> systemProperties = null;
        block25: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case HEAP: {
                            updates.addAll(ModelXmlParsers.parseHeap(reader));
                            continue block25;
                        }
                        case PERMGEN: {
                            updates.addAll(ModelXmlParsers.parsePermgen(reader));
                            continue block25;
                        }
                        case STACK: {
                            updates.addAll(ModelXmlParsers.parseStack(reader));
                            continue block25;
                        }
                        case AGENT_LIB: {
                            updates.addAll(ModelXmlParsers.parseAgentLib(reader));
                            continue block25;
                        }
                        case AGENT_PATH: {
                            updates.addAll(ModelXmlParsers.parseAgentPath(reader));
                            continue block25;
                        }
                        case JAVA_AGENT: {
                            updates.addAll(ModelXmlParsers.parseJavaagent(reader));
                            continue block25;
                        }
                        case ENVIRONMENT_VARIABLES: {
                            if (environmentVariables != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            environmentVariables = ModelXmlParsers.parseProperties(reader, Element.VARIABLE, true);
                            for (PropertyAdd propAdd : environmentVariables) {
                                updates.add(new JvmEnvironmentVariableUpdate(propAdd));
                            }
                            continue block25;
                        }
                        case SYSTEM_PROPERTIES: {
                            if (systemProperties != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            systemProperties = ModelXmlParsers.parseProperties(reader, Element.PROPERTY, true);
                            for (PropertyAdd propAdd : systemProperties) {
                                updates.add(new JvmSystemPropertiesUpdate(propAdd));
                            }
                            continue block25;
                        }
                        case JVM_OPTIONS: {
                            if (jvmOptions != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            jvmOptions = ModelXmlParsers.parseJvmOptions(reader);
                            for (JvmOptionAdd optAdd : jvmOptions) {
                                updates.add(new JvmOptionsUpdate(optAdd));
                            }
                            continue block25;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return new NamedModelUpdates<JvmElement>(name, updates);
    }

    static List<AbstractModelUpdate<JvmElement, ?>> parseHeap(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    updates.add(new JvmHeapUpdate(value));
                    continue block4;
                }
                case MAX_SIZE: {
                    updates.add(new JvmMaxHeapUpdate(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        return updates;
    }

    static List<AbstractModelUpdate<JvmElement, ?>> parsePermgen(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    updates.add(new JvmPermgenUpdate(value));
                    continue block4;
                }
                case MAX_SIZE: {
                    updates.add(new JvmMaxPermgenUpdate(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        return updates;
    }

    static List<AbstractModelUpdate<JvmElement, ?>> parseStack(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    updates.add(new JvmStackUpdate(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (updates.size() == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SIZE));
        }
        ParseUtils.requireNoContent(reader);
        return updates;
    }

    static List<AbstractModelUpdate<JvmElement, ?>> parseAgentLib(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    updates.add(new JvmAgentLibUpdate(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (updates.size() == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
        return updates;
    }

    static List<AbstractModelUpdate<JvmElement, ?>> parseAgentPath(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    updates.add(new JvmAgentPathUpdate(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (updates.size() == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
        return updates;
    }

    static List<AbstractModelUpdate<JvmElement, ?>> parseJavaagent(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList updates = new ArrayList();
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    updates.add(new JvmJavaagentUpdate(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (updates.size() == 0) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
        return updates;
    }

    static Collection<JvmOptionAdd> parseJvmOptions(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList<JvmOptionAdd> options = new ArrayList<JvmOptionAdd>();
        ParseUtils.requireNoAttributes(reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (element == Element.OPTION) {
                        String option = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            String attrValue = reader.getAttributeValue(i);
                            if (reader.getAttributeNamespace(i) != null) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case VALUE: {
                                    option = attrValue;
                                    continue block7;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute(reader, i);
                                }
                            }
                        }
                        if (option == null) {
                            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
                        }
                        options.add(new JvmOptionAdd(option));
                        ParseUtils.requireNoContent(reader);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (options.size() == 0) {
            throw ParseUtils.missingRequiredElement(reader, Collections.singleton(Element.OPTION));
        }
        return options;
    }

    static NameOffset parseSocketBindingGroupRef(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        int offset = -1;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REF: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                    }
                    name = value;
                    continue block6;
                }
                case PORT_OFFSET: {
                    try {
                        if (offset != -1) {
                            throw ParseUtils.duplicateAttribute(reader, attribute.getLocalName());
                        }
                        offset = Integer.parseInt(value);
                        if (offset >= 0) continue block6;
                        throw new XMLStreamException(offset + " is not a valid " + attribute.getLocalName() + " -- must be greater than zero", reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException(offset + " is not a valid " + attribute.getLocalName(), reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.REF));
        }
        ParseUtils.requireNoContent(reader);
        return new NameOffset(name, offset);
    }

    static void parseManagement(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        String interfaceName = null;
        int port = 0;
        int maxThreads = -1;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    interfaceName = value;
                    continue block5;
                }
                case PORT: {
                    port = Integer.parseInt(value);
                    if (port >= 0) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be negative", reader.getLocation());
                }
                case MAX_THREADS: {
                    maxThreads = Integer.parseInt(value);
                    if (maxThreads >= 1) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + maxThreads + " -- must be greater than 0", reader.getLocation());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (interfaceName == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        list.add(new HostManagementSocketAdd(interfaceName, port));
        if (maxThreads > 0) {
            list.add(new HostManagementSocketThreadsUpdate(maxThreads));
        }
        reader.discardRemainder();
    }

    static void parseServerManagement(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> list) throws XMLStreamException {
        String interfaceName = null;
        int port = 0;
        int maxThreads = -1;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INTERFACE: {
                    interfaceName = value;
                    continue block5;
                }
                case PORT: {
                    port = Integer.parseInt(value);
                    if (port >= 0) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be negative", reader.getLocation());
                }
                case MAX_THREADS: {
                    maxThreads = Integer.parseInt(value);
                    if (maxThreads >= 1) continue block5;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + maxThreads + " -- must be greater than 0", reader.getLocation());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (interfaceName == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        list.add(new ServerModelManagementSocketAdd(interfaceName, port));
        if (maxThreads > 0) {
            list.add(new ServerModelManagementSocketThreadsUpdate(maxThreads));
        }
        reader.discardRemainder();
    }

    static void parseDomainController(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        boolean hasLocal = false;
        boolean hasRemote = false;
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case LOCAL: {
                            if (hasLocal) {
                                throw new XMLStreamException("Child " + element.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                            }
                            if (hasRemote) {
                                throw new XMLStreamException("Child " + Element.REMOTE.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                            }
                            ParseUtils.requireNoAttributes(reader);
                            ParseUtils.requireNoContent(reader);
                            list.add(new HostLocalDomainControllerAdd());
                            hasLocal = true;
                            continue block7;
                        }
                        case REMOTE: {
                            if (hasRemote) {
                                throw new XMLStreamException("Child " + element.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                            }
                            if (hasLocal) {
                                throw new XMLStreamException("Child " + Element.LOCAL.getLocalName() + " of element " + Element.DOMAIN_CONTROLLER.getLocalName() + " already declared", reader.getLocation());
                            }
                            ModelXmlParsers.parseRemoteDomainController(reader, list);
                            hasRemote = true;
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!hasLocal && !hasRemote) {
            throw new XMLStreamException("Either a " + Element.REMOTE.getLocalName() + " or " + Element.LOCAL.getLocalName() + " domain controller configuration must be declared.", reader.getLocation());
        }
    }

    static void parseRemoteDomainController(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        String host = null;
        Integer port = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    host = value;
                    continue block4;
                }
                case PORT: {
                    port = Integer.valueOf(value);
                    if (port >= 1) continue block4;
                    throw new XMLStreamException("Illegal '" + attribute.getLocalName() + "' value " + port + " -- cannot be less than one", reader.getLocation());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (host == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.HOST.getLocalName()));
        }
        if (port == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PORT.getLocalName()));
        }
        list.add(new HostRemoteDomainControllerAdd(host, port));
        reader.discardRemainder();
    }

    static void parseServers(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> names = new HashSet<String>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case SERVER: {
                            ModelXmlParsers.parseServer(reader, list, names);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    static void parseServer(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list, Set<String> serverNames) throws XMLStreamException {
        String name = null;
        String group = null;
        Boolean start = null;
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (!serverNames.add(value)) {
                        throw new XMLStreamException("Duplicate server declaration " + value, reader.getLocation());
                    }
                    name = value;
                    continue block15;
                }
                case GROUP: {
                    group = value;
                    continue block15;
                }
                case START: {
                    start = Boolean.valueOf(value);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (group == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.GROUP));
        }
        list.add(new HostServerAdd(name, group));
        NamedModelUpdates<JvmElement> jvm = null;
        Collection<PropertyAdd> systemProperties = null;
        NameOffset socketBinding = null;
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case INTERFACE_SPECS: {
                            ModelXmlParsers.parseServerElementInterfaces(name, reader, list);
                            continue block16;
                        }
                        case JVM: {
                            if (jvm != null) {
                                throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                            }
                            jvm = ModelXmlParsers.parseJvm(reader);
                            list.add(HostServerUpdate.create(name, new ServerElementJvmAdd(jvm.name)));
                            for (AbstractModelUpdate abstractModelUpdate : jvm.updates) {
                                list.add(HostServerUpdate.create(name, ServerElementJvmUpdate.create(abstractModelUpdate)));
                            }
                            continue block16;
                        }
                        case PATHS: {
                            for (PathElementUpdate pathElementUpdate : ModelXmlParsers.parsePaths(reader, true)) {
                                list.add(HostServerUpdate.create(name, new ServerElementPathAdd(pathElementUpdate)));
                            }
                        }
                        case SOCKET_BINDING_GROUP: {
                            if (socketBinding != null) {
                                throw new XMLStreamException(element.getLocalName() + " already defined", reader.getLocation());
                            }
                            socketBinding = ModelXmlParsers.parseSocketBindingGroupRef(reader);
                            list.add(HostServerUpdate.create(name, new ServerElementSocketBindingGroupUpdate(socketBinding.name)));
                            if (socketBinding.offset <= 0) continue block16;
                            list.add(HostServerUpdate.create(name, new ServerElementSocketBindingPortOffsetUpdate(socketBinding.offset)));
                            continue block16;
                        }
                        case SYSTEM_PROPERTIES: {
                            if (systemProperties != null) {
                                throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                            }
                            systemProperties = ModelXmlParsers.parseProperties(reader, Element.PROPERTY, true);
                            for (PropertyAdd propertyAdd : systemProperties) {
                                list.add(HostServerUpdate.create(name, new ServerElementSystemPropertyUpdate(propertyAdd)));
                            }
                            continue block16;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        boolean isStart = start == null ? true : start;
        list.add(HostServerUpdate.create(name, new ServerElementStartStopUpdate(isStart)));
    }

    static void parseDomainPaths(XMLExtendedStreamReader reader, List<? super AbstractDomainModelUpdate<?>> list) throws XMLStreamException {
        for (PathElementUpdate update : ModelXmlParsers.parsePaths(reader, false)) {
            list.add(new DomainPathAdd(update));
        }
    }

    static void parseHostPaths(XMLExtendedStreamReader reader, List<? super AbstractHostModelUpdate<?>> list) throws XMLStreamException {
        for (PathElementUpdate update : ModelXmlParsers.parsePaths(reader, true)) {
            list.add(new HostPathAdd(update));
        }
    }

    static void parseServerModelPaths(XMLExtendedStreamReader reader, List<? super AbstractServerModelUpdate<?>> list) throws XMLStreamException {
        for (PathElementUpdate update : ModelXmlParsers.parsePaths(reader, true)) {
            list.add(new ServerPathAdd(update));
        }
    }

    static Collection<PathElementUpdate> parsePaths(XMLExtendedStreamReader reader, boolean requirePath) throws XMLStreamException {
        LinkedHashSet<String> pathNames = new LinkedHashSet<String>();
        ArrayList<PathElementUpdate> updates = new ArrayList<PathElementUpdate>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case PATH: {
                            PathElementUpdate update = ModelXmlParsers.parsePath(reader, requirePath);
                            if (!pathNames.add(update.getName())) {
                                throw new XMLStreamException(update.getName() + " already defined", reader.getLocation());
                            }
                            updates.add(update);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return updates;
    }

    static PathElementUpdate parsePath(XMLExtendedStreamReader reader, boolean requirePath) throws XMLStreamException {
        String name = null;
        String path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    if (!PathElement.RESTRICTED.contains(value)) continue block5;
                    throw ParseUtils.invalidAttributeValue(reader, i);
                }
                case PATH: {
                    path = value;
                    continue block5;
                }
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.NAME));
        }
        if (requirePath && path == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent(reader);
        return new PathElementUpdate(name, path, relativeTo);
    }

    private static Element nextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.nextTag() == 2) {
            return null;
        }
        if (Namespace.forUri(reader.getNamespaceURI()) != Namespace.DOMAIN_1_0) {
            throw ParseUtils.unexpectedElement(reader);
        }
        return Element.forName(reader.getLocalName());
    }

    private static int parsePort(String value, Attribute attribute, XMLExtendedStreamReader reader, boolean allowEphemeral) throws XMLStreamException {
        int legal;
        try {
            int min;
            legal = Integer.parseInt(value);
            int n = min = allowEphemeral ? 0 : 1;
            if (legal < min || legal >= 65536) {
                throw new XMLStreamException("Illegal value " + value + " for attribute '" + attribute.getLocalName() + "' must be between " + min + " and 65536", reader.getLocation());
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLStreamException("Illegal value " + value + " for attribute '" + attribute.getLocalName() + "' must be an integer", reader.getLocation(), nfe);
        }
        return legal;
    }

    static class NameOffset {
        final String name;
        final int offset;

        NameOffset(String name, int offset) {
            this.name = name;
            this.offset = offset;
        }
    }

    static class NamedModelUpdates<E extends AbstractModelElement<E>> {
        final String name;
        final List<AbstractModelUpdate<E, ?>> updates;

        NamedModelUpdates(String name, List<AbstractModelUpdate<E, ?>> updates) {
            this.name = name;
            this.updates = updates;
        }
    }

    private static class ExtensionContextImpl
    implements ExtensionContext {
        private final XMLExtendedStreamReader reader;

        public ExtensionContextImpl(XMLExtendedStreamReader reader) {
            this.reader = reader;
        }

        @Override
        public <E extends AbstractSubsystemElement<E>> void registerSubsystem(String namespaceUri, XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<E>>> elementReader) {
            XMLMapper mapper = this.reader.getXMLMapper();
            mapper.registerRootElement(new QName(namespaceUri, Element.SUBSYSTEM.getLocalName()), elementReader);
        }
    }
}

