/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerExtensionAdd;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModelDeploymentAdd;
import org.jboss.as.model.ServerModelDeploymentStartStopUpdate;
import org.jboss.as.model.ServerModelInterfaceAdd;
import org.jboss.as.model.ServerNameUpdate;
import org.jboss.as.model.ServerPathAdd;
import org.jboss.as.model.ServerPortOffsetUpdate;
import org.jboss.as.model.ServerProfileUpdate;
import org.jboss.as.model.ServerSocketBindingGroupUpdate;
import org.jboss.as.model.ServerSocketBindingUpdate;
import org.jboss.as.model.ServerSubsystemAdd;
import org.jboss.as.model.ServerSubsystemUpdate;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.as.model.socket.SocketBindingAdd;
import org.jboss.as.model.socket.SocketBindingElement;
import org.jboss.as.model.socket.SocketBindingGroupElement;
import org.jboss.as.model.socket.SocketBindingGroupUpdate;

public final class ServerFactory {
    private ServerFactory() {
    }

    public static void combine(DomainModel domainModel, HostModel hostModel, String serverName, List<AbstractServerModelUpdate<?>> list) {
        ServerElement serverElement = hostModel.getServer(serverName);
        if (serverElement == null) {
            throw new IllegalArgumentException("Host model does not contain a server named '" + serverName + "'");
        }
        String serverGroupName = serverElement.getServerGroup();
        ServerGroupElement serverGroup = domainModel.getServerGroup(serverGroupName);
        if (serverGroup == null) {
            throw new IllegalArgumentException("Domain model does not contain a server group named '" + serverGroupName + "'");
        }
        String profileName = serverGroup.getProfileName();
        ProfileElement leafProfile = domainModel.getProfile(profileName);
        if (profileName == null) {
            throw new IllegalArgumentException("Domain model does not contain a profile named '" + profileName + "'");
        }
        list.add(new ServerNameUpdate(serverName));
        LinkedHashSet<String> extensionNames = new LinkedHashSet<String>();
        for (String name : domainModel.getExtensions()) {
            extensionNames.add(name);
        }
        for (String name : hostModel.getExtensions()) {
            extensionNames.add(name);
        }
        for (String name : extensionNames) {
            list.add(new ServerExtensionAdd(name));
        }
        HashSet<String> unspecifiedPaths = new HashSet<String>();
        HashMap<String, ServerPathAdd> paths = new HashMap<String, ServerPathAdd>();
        for (PathElement path : domainModel.getPaths()) {
            if (!path.isSpecified()) {
                unspecifiedPaths.add(path.getName());
                continue;
            }
            paths.put(path.getName(), new ServerPathAdd(path));
        }
        for (PathElement path : hostModel.getPaths()) {
            unspecifiedPaths.remove(path.getName());
            paths.put(path.getName(), new ServerPathAdd(path));
        }
        for (PathElement path : serverElement.getPaths()) {
            unspecifiedPaths.remove(path.getName());
            paths.put(path.getName(), new ServerPathAdd(path));
        }
        if (unspecifiedPaths.size() > 0) {
            throw new IllegalStateException("unspecified paths " + unspecifiedPaths);
        }
        HashSet<String> unspecifiedInterfaces = new HashSet<String>();
        HashMap<String, InterfaceElement> interfaces = new HashMap<String, InterfaceElement>();
        for (InterfaceElement ie : domainModel.getInterfaces()) {
            if (ie.isFullySpecified()) {
                interfaces.put(ie.getName(), ie);
                continue;
            }
            unspecifiedInterfaces.add(ie.getName());
        }
        for (InterfaceElement ie : hostModel.getInterfaces()) {
            interfaces.put(ie.getName(), ie);
            unspecifiedInterfaces.remove(ie.getName());
        }
        for (InterfaceElement ie : serverElement.getInterfaces()) {
            interfaces.put(ie.getName(), ie);
            unspecifiedInterfaces.remove(ie.getName());
        }
        for (InterfaceElement interfaceElement : interfaces.values()) {
            list.add(new ServerModelInterfaceAdd(new InterfaceAdd(interfaceElement)));
        }
        String bindingRef = serverElement.getSocketBindingGroupName();
        int portOffset = serverElement.getSocketBindingPortOffset();
        if (bindingRef == null) {
            bindingRef = serverGroup.getSocketBindingGroupName();
            portOffset = serverGroup.getSocketBindingPortOffset();
        }
        list.add(new ServerPortOffsetUpdate(portOffset));
        SocketBindingGroupElement domainBindings = domainModel.getSocketBindingGroup(bindingRef);
        if (domainBindings == null) {
            domainBindings = new SocketBindingGroupElement("domainBindings");
        }
        list.add(new ServerSocketBindingGroupUpdate(new SocketBindingGroupUpdate(domainBindings.getName(), domainBindings.getDefaultInterface(), Collections.<String>emptySet())));
        ServerFactory.processSocketBindings(domainBindings, list);
        for (String socketInclude : domainBindings.getIncludedSocketBindingGroups()) {
            SocketBindingGroupElement include = domainModel.getSocketBindingGroup(socketInclude);
            if (include == null) {
                throw new IllegalStateException("failed to resolve binding-group " + socketInclude);
            }
            ServerFactory.processSocketBindings(include, list);
        }
        list.add(new ServerProfileUpdate(serverGroup.getProfileName()));
        HashSet<String> processedSubsystems = new HashSet<String>();
        HashSet<String> processedProfiles = new HashSet<String>();
        ServerFactory.processProfile(domainModel, leafProfile, list, processedProfiles, processedSubsystems);
        for (ServerGroupDeploymentElement element : serverGroup.getDeployments()) {
            ServerModelDeploymentAdd add = new ServerModelDeploymentAdd(element.getUniqueName(), element.getRuntimeName(), element.getSha1Hash());
            list.add(add);
            if (!element.isStart()) continue;
            list.add(new ServerModelDeploymentStartStopUpdate(element.getUniqueName(), true));
        }
    }

    private static void processProfile(DomainModel domainModel, ProfileElement profile, List<AbstractServerModelUpdate<?>> list, Set<String> processedProfiles, Set<String> processedSubsystems) {
        if (!processedProfiles.add(profile.getName())) {
            return;
        }
        for (String string : profile.getIncludedProfiles()) {
            ServerFactory.processProfile(domainModel, domainModel.getProfile(string), list, processedProfiles, processedSubsystems);
        }
        for (AbstractSubsystemElement abstractSubsystemElement : profile.getSubsystems()) {
            String namespaceURI = abstractSubsystemElement.getElementName().getNamespaceURI();
            if (processedSubsystems.contains(namespaceURI)) {
                throw ServerFactory.findDuplicateProfile(namespaceURI, profile.getName(), processedProfiles, domainModel);
            }
            ServerFactory.processSubsystem(abstractSubsystemElement, list);
            processedSubsystems.add(namespaceURI);
        }
    }

    private static RuntimeException findDuplicateProfile(String namespaceURI, String currentProfile, Set<String> processedProfiles, DomainModel domainModel) {
        String duplicate = null;
        for (String profile : processedProfiles) {
            ProfileElement pe;
            if (profile.equals(currentProfile) || (pe = domainModel.getProfile(profile)).getSubsystem(namespaceURI) == null) continue;
            duplicate = profile;
            break;
        }
        return new IllegalStateException(String.format("Subsystem with namespace %s is declared in multiple profiles that are related to each other via inclusion. Profiles are %s and %s. A subsystem can only appear once in a given server runtime, so declaring the same subsystem in multiple related profiles is illegal.", namespaceURI, duplicate, currentProfile));
    }

    private static void processSocketBindings(SocketBindingGroupElement group, List<AbstractServerModelUpdate<?>> list) {
        for (SocketBindingElement binding : group.getSocketBindings()) {
            SocketBindingAdd update = new SocketBindingAdd(binding);
            list.add(new ServerSocketBindingUpdate(update));
        }
    }

    private static <E extends AbstractSubsystemElement<E>> void processSubsystem(E subsystemElement, List<AbstractServerModelUpdate<?>> list) {
        AbstractSubsystemAdd<E> subsystemAdd = subsystemElement.getAdd();
        if (subsystemAdd == null) {
            throw new IllegalStateException(subsystemElement + " did not provide an " + AbstractSubsystemAdd.class.getSimpleName());
        }
        list.add(new ServerSubsystemAdd(subsystemAdd));
        ArrayList subsystemList = new ArrayList();
        subsystemElement.getUpdates(subsystemList);
        for (AbstractSubsystemUpdate update : subsystemList) {
            list.add(ServerSubsystemUpdate.create(update));
        }
    }
}

