/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModel;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.DeploymentRepositoryElement;
import org.jboss.as.model.Element;
import org.jboss.as.model.ManagementElement;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.as.model.socket.SocketBindingGroupElement;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ServerModel
extends AbstractModel<ServerModel> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "model"});
    public static final String DEFAULT_STANDALONE_NAME;
    private static final long serialVersionUID = -7764186426598416630L;
    private static final Logger log;
    private static final QName ELEMENT_NAME;
    private String configuredServerName;
    private final Set<String> extensions = new LinkedHashSet<String>();
    private final Map<String, DeploymentRepositoryElement> repositories = new LinkedHashMap<String, DeploymentRepositoryElement>();
    private final Map<String, ServerGroupDeploymentElement> deployments = new LinkedHashMap<String, ServerGroupDeploymentElement>();
    private final Map<String, InterfaceElement> interfaces = new LinkedHashMap<String, InterfaceElement>();
    private final Map<String, PathElement> paths = new LinkedHashMap<String, PathElement>();
    private ProfileElement profile;
    private SocketBindingGroupElement socketBindings;
    private int portOffset;
    private final PropertiesElement systemProperties = new PropertiesElement(Element.PROPERTY, true);
    private ManagementElement managementElement;

    public ServerModel() {
        super(ELEMENT_NAME);
    }

    public ServerModel(String serverName, int portOffset) {
        super(ELEMENT_NAME);
        this.configuredServerName = serverName;
        this.portOffset = portOffset;
    }

    public String getServerName() {
        return this.configuredServerName == null ? DEFAULT_STANDALONE_NAME : this.configuredServerName;
    }

    void setServerName(String name) {
        this.configuredServerName = name;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public PropertiesElement getSystemProperties() {
        return this.systemProperties;
    }

    public ServerGroupDeploymentElement getDeployment(String deploymentName) {
        return this.deployments.get(deploymentName);
    }

    public Collection<String> getDeploymentRepositories() {
        return new HashSet<String>(this.repositories.keySet());
    }

    public DeploymentRepositoryElement getDeploymentRepository(String path) {
        return this.repositories.get(path);
    }

    public Collection<PathElement> getPaths() {
        return Collections.unmodifiableCollection(new HashSet<PathElement>(this.paths.values()));
    }

    public PathElement getPath(String name) {
        return this.paths.get(name);
    }

    public ManagementElement getManagementElement() {
        return this.managementElement;
    }

    @Override
    protected Class<ServerModel> getElementClass() {
        return ServerModel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.configuredServerName != null) {
            streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.configuredServerName);
        }
        this.writeNamespaces(streamWriter);
        if (!this.extensions.isEmpty()) {
            streamWriter.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (String string : this.extensions) {
                streamWriter.writeEmptyElement(Element.EXTENSION.getLocalName());
                streamWriter.writeAttribute(Attribute.MODULE.getLocalName(), string);
            }
            streamWriter.writeEndElement();
        }
        Iterator<ServerGroupDeploymentElement> i$ = this.paths;
        synchronized (i$) {
            if (!this.paths.isEmpty()) {
                streamWriter.writeStartElement(Element.PATHS.getLocalName());
                for (PathElement path : this.paths.values()) {
                    streamWriter.writeStartElement(Element.PATH.getLocalName());
                    path.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        if (this.managementElement != null) {
            streamWriter.writeStartElement(Element.MANAGEMENT.getLocalName());
            this.managementElement.writeContent(streamWriter);
        }
        streamWriter.writeStartElement(Element.PROFILE.getLocalName());
        this.profile.writeContent(streamWriter);
        i$ = this.interfaces;
        synchronized (i$) {
            if (!this.interfaces.isEmpty()) {
                streamWriter.writeStartElement(Element.INTERFACES.getLocalName());
                for (InterfaceElement element : this.interfaces.values()) {
                    streamWriter.writeStartElement(Element.INTERFACE.getLocalName());
                    element.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        if (this.socketBindings != null) {
            streamWriter.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
            this.socketBindings.writeContent(streamWriter);
        }
        if (this.systemProperties != null && this.systemProperties.size() > 0) {
            streamWriter.writeStartElement(Element.SYSTEM_PROPERTIES.getLocalName());
            this.systemProperties.writeContent(streamWriter);
        }
        if (!this.repositories.isEmpty()) {
            for (DeploymentRepositoryElement deploymentRepositoryElement : this.repositories.values()) {
                streamWriter.writeStartElement(Element.DEPLOYMENT_REPOSITORY.getLocalName());
                deploymentRepositoryElement.writeContent(streamWriter);
            }
        }
        if (!this.deployments.isEmpty()) {
            streamWriter.writeStartElement(Element.DEPLOYMENTS.getLocalName());
            for (ServerGroupDeploymentElement serverGroupDeploymentElement : this.deployments.values()) {
                streamWriter.writeStartElement(Element.DEPLOYMENT.getLocalName());
                serverGroupDeploymentElement.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    boolean addExtension(String name) {
        return this.extensions.add(name);
    }

    AbstractSubsystemElement<?> getSubsystem(String namespaceUri) {
        return this.profile.getSubsystem(namespaceUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeployment(ServerGroupDeploymentElement deploymentElement) {
        Map<String, ServerGroupDeploymentElement> map = this.deployments;
        synchronized (map) {
            if (this.deployments.put(deploymentElement.getUniqueName(), deploymentElement) != null) {
                throw new IllegalArgumentException("Deployment " + deploymentElement.getUniqueName() + " with sha1 hash " + ServerModel.bytesToHexString(deploymentElement.getSha1Hash()) + " already declared");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerGroupDeploymentElement removeDeployment(String deploymentName) {
        Map<String, ServerGroupDeploymentElement> map = this.deployments;
        synchronized (map) {
            return this.deployments.remove(deploymentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerGroupDeploymentElement> getDeployments() {
        Map<String, ServerGroupDeploymentElement> map = this.deployments;
        synchronized (map) {
            return new HashSet<ServerGroupDeploymentElement>(this.deployments.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceElement getInterface(String name) {
        Map<String, InterfaceElement> map = this.interfaces;
        synchronized (map) {
            return this.interfaces.get(name);
        }
    }

    boolean addSubsystem(String namespaceUri, AbstractSubsystemElement<?> element) {
        return this.profile.addSubsystem(namespaceUri, element);
    }

    public ProfileElement getProfile() {
        return this.profile;
    }

    void setProfile(ProfileElement profile) {
        this.profile = profile;
    }

    SocketBindingGroupElement getSocketBindings() {
        return this.socketBindings;
    }

    void setSocketBindings(SocketBindingGroupElement socketBindings) {
        this.socketBindings = socketBindings;
    }

    InterfaceElement addInterface(String name) {
        if (this.interfaces.containsKey(name)) {
            return null;
        }
        InterfaceElement element = new InterfaceElement(name);
        this.interfaces.put(name, element);
        return element;
    }

    boolean removeInterface(String name) {
        return this.interfaces.remove(name) != null;
    }

    PathElement addPath(String name) {
        if (this.paths.containsKey(name)) {
            return null;
        }
        PathElement path = new PathElement(name);
        this.paths.put(name, path);
        return path;
    }

    boolean removePath(String name) {
        return this.paths.remove(name) != null;
    }

    boolean addDeploymentRepository(String path) {
        if (this.repositories.containsKey(path)) {
            return false;
        }
        DeploymentRepositoryElement repository = new DeploymentRepositoryElement(path);
        this.repositories.put(path, repository);
        return true;
    }

    boolean removeDeploymentRepository(String path) {
        return this.repositories.remove(path) != null;
    }

    boolean addManagementElement(String interfaceName, int port) {
        if (this.managementElement != null) {
            return false;
        }
        this.managementElement = new ManagementElement(interfaceName, port);
        return true;
    }

    boolean removeManagementElement() {
        if (this.managementElement != null) {
            this.managementElement = null;
            return true;
        }
        return false;
    }

    static {
        try {
            DEFAULT_STANDALONE_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        log = Logger.getLogger((String)"org.jboss.as.server");
        ELEMENT_NAME = new QName(Namespace.CURRENT.getUriString(), Element.SERVER.getLocalName());
    }
}

