/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Arrays;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.ServerModelDeploymentRemove;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;

public class ServerModelDeploymentAdd
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = -5804608026829597800L;
    private final String deploymentUniqueName;
    private final String deploymentRuntimeName;
    private final byte[] deploymentHash;

    public ServerModelDeploymentAdd(String deploymentUniqueName, String deploymentRuntimeName, byte[] deploymentHash) {
        super(false, true);
        if (deploymentUniqueName == null) {
            throw new IllegalArgumentException("deploymentUniqueName is null");
        }
        if (deploymentRuntimeName == null) {
            throw new IllegalArgumentException("deploymentRuntimeName is null");
        }
        if (deploymentHash == null) {
            throw new IllegalArgumentException("deploymentHash is null");
        }
        this.deploymentUniqueName = deploymentUniqueName;
        this.deploymentRuntimeName = deploymentRuntimeName;
        this.deploymentHash = deploymentHash;
    }

    public ServerModelDeploymentRemove getCompensatingUpdate(ServerModel original) {
        return new ServerModelDeploymentRemove(this.deploymentUniqueName);
    }

    @Override
    public void applyUpdate(ServerModel serverModel) throws UpdateFailedException {
        ServerGroupDeploymentElement existing = serverModel.getDeployment(this.deploymentUniqueName);
        if (existing != null) {
            if (!Arrays.equals(existing.getSha1Hash(), this.deploymentHash)) {
                throw new UpdateFailedException("Deployment content with name " + this.deploymentUniqueName + " and hash " + existing.getSha1HashAsHexString() + "already ");
            }
        } else {
            serverModel.addDeployment(new ServerGroupDeploymentElement(this.deploymentUniqueName, this.deploymentRuntimeName, this.deploymentHash, false));
        }
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        if (resultHandler != null) {
            resultHandler.handleSuccess(null, param);
        }
    }
}

