/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerDeploymentStartStopHandler;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;

public class ServerModelDeploymentReplaceUpdate
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 5773083013951607950L;
    private final String newDeployment;
    private final String newDeploymentRuntimeName;
    private final byte[] newDeploymentHash;
    private final String toReplace;
    private final ServerDeploymentStartStopHandler startStopHandler;
    private ServerGroupDeploymentElement deploymentElement;

    public ServerModelDeploymentReplaceUpdate(String newDeployment, String newDeploymentRuntimeName, byte[] newDeploymentHash, String toReplace) {
        super(false, true);
        if (newDeployment == null) {
            throw new IllegalArgumentException("newDeployment is null");
        }
        if (newDeploymentRuntimeName == null) {
            throw new IllegalArgumentException("newDeploymentRuntimeName is null");
        }
        if (newDeploymentHash == null) {
            throw new IllegalArgumentException("newDeploymentHash is null");
        }
        if (toReplace == null) {
            throw new IllegalArgumentException("toReplace is null");
        }
        this.newDeployment = newDeployment;
        this.toReplace = toReplace;
        this.startStopHandler = new ServerDeploymentStartStopHandler();
        this.newDeploymentRuntimeName = newDeploymentRuntimeName;
        this.newDeploymentHash = newDeploymentHash;
    }

    public ServerModelDeploymentReplaceUpdate(String newDeployment, String toReplace) {
        super(false, true);
        if (newDeployment == null) {
            throw new IllegalArgumentException("newDeployment is null");
        }
        if (toReplace == null) {
            throw new IllegalArgumentException("toReplace is null");
        }
        this.newDeployment = newDeployment;
        this.toReplace = toReplace;
        this.startStopHandler = new ServerDeploymentStartStopHandler();
        this.newDeploymentRuntimeName = null;
        this.newDeploymentHash = null;
    }

    @Override
    public void applyUpdate(ServerModel standalone) throws UpdateFailedException {
        ServerGroupDeploymentElement undeploymentElement = standalone.getDeployment(this.toReplace);
        if (undeploymentElement == null) {
            throw new UpdateFailedException("Unknown deployment " + this.newDeployment);
        }
        if (this.newDeploymentRuntimeName != null) {
            standalone.addDeployment(new ServerGroupDeploymentElement(this.newDeployment, this.newDeploymentRuntimeName, this.newDeploymentHash, false));
        }
        this.deploymentElement = standalone.getDeployment(this.newDeployment);
        if (this.deploymentElement == null) {
            throw new UpdateFailedException("Unknown deployment " + this.newDeployment);
        }
        undeploymentElement.setStart(false);
        this.deploymentElement.setStart(true);
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        if (this.deploymentElement != null) {
            this.startStopHandler.redeploy(this.newDeployment, this.deploymentElement.getRuntimeName(), this.deploymentElement.getSha1Hash(), updateContext.getServiceContainer(), resultHandler, param);
        } else if (resultHandler != null) {
            resultHandler.handleFailure(new IllegalStateException("Unknown deployment " + this.newDeployment), param);
        }
    }

    public ServerModelDeploymentReplaceUpdate getCompensatingUpdate(ServerModel original) {
        ServerGroupDeploymentElement deploymentElement = original.getDeployment(this.newDeployment);
        ServerGroupDeploymentElement undeploymentElement = original.getDeployment(this.toReplace);
        if (deploymentElement == null || undeploymentElement == null) {
            return null;
        }
        return new ServerModelDeploymentReplaceUpdate(this.toReplace, this.newDeployment);
    }
}

