/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerDeploymentStartStopHandler;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;

public class ServerModelDeploymentStartStopUpdate
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 5773083013951607950L;
    private final ServerDeploymentStartStopHandler startStopHandler;
    private ServerGroupDeploymentElement deploymentElement;
    private final String deploymentUnitName;
    private final boolean isStart;

    public ServerModelDeploymentStartStopUpdate(String deploymentUnitName, boolean isStart) {
        super(false, true);
        if (deploymentUnitName == null) {
            throw new IllegalArgumentException("deploymentUnitName is null");
        }
        this.deploymentUnitName = deploymentUnitName;
        this.isStart = isStart;
        this.startStopHandler = new ServerDeploymentStartStopHandler();
    }

    public String getDeploymentUnitName() {
        return this.deploymentUnitName;
    }

    public ServerModelDeploymentStartStopUpdate getCompensatingUpdate(ServerModel original) {
        ServerGroupDeploymentElement element = original.getDeployment(this.getDeploymentUnitName());
        if (element == null) {
            return null;
        }
        return new ServerModelDeploymentStartStopUpdate(this.deploymentUnitName, !this.isStart);
    }

    @Override
    public void applyUpdate(ServerModel serverModel) throws UpdateFailedException {
        this.deploymentElement = serverModel.getDeployment(this.getDeploymentUnitName());
        if (this.deploymentElement != null) {
            this.deploymentElement.setStart(this.isStart);
        }
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        if (this.deploymentElement != null) {
            if (this.isStart) {
                this.startStopHandler.deploy(this.deploymentElement.getUniqueName(), this.deploymentElement.getRuntimeName(), this.deploymentElement.getSha1Hash(), updateContext.getBatchBuilder(), updateContext.getServiceContainer(), resultHandler, param);
            } else {
                this.startStopHandler.undeploy(this.getDeploymentUnitName(), updateContext.getServiceContainer(), resultHandler, param);
            }
        } else if (resultHandler != null) {
            resultHandler.handleSuccess(null, param);
        }
    }
}

