/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.ServerModelInterfaceAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.model.socket.InterfaceAdd;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.as.services.net.NetworkInterfaceService;
import org.jboss.msc.service.ServiceController;

public class ServerModelInterfaceRemove
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = -4178671085310775352L;
    private final String interfaceName;

    public ServerModelInterfaceRemove(String name) {
        this.interfaceName = name;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        if (element.removeInterface(this.interfaceName)) {
            throw new UpdateFailedException(String.format("network interface (%s) not found", this.interfaceName));
        }
    }

    @Override
    public AbstractServerModelUpdate<?> getCompensatingUpdate(ServerModel original) {
        InterfaceElement element = original.getInterface(this.interfaceName);
        if (element == null) {
            return null;
        }
        return new ServerModelInterfaceAdd(new InterfaceAdd(element));
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController controller = updateContext.getServiceContainer().getService(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{this.interfaceName}));
        if (controller == null) {
            resultHandler.handleSuccess(null, param);
            return;
        }
        controller.addListener(new UpdateResultHandler.ServiceRemoveListener<P>(resultHandler, param));
    }
}

