/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelElementUpdate;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.ProfileElement;
import org.jboss.as.model.UpdateFailedException;

public final class SubsystemRemove
extends AbstractModelElementUpdate<ProfileElement> {
    private static final long serialVersionUID = -5436702014420361771L;
    private final String namespaceUri;

    protected SubsystemRemove(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    @Override
    public AbstractSubsystemAdd<?> getCompensatingUpdate(ProfileElement original) {
        return original.getSubsystem(this.namespaceUri).getAdd();
    }

    @Override
    public Class<ProfileElement> getModelElementType() {
        return ProfileElement.class;
    }

    @Override
    protected void applyUpdate(ProfileElement element) throws UpdateFailedException {
        AbstractSubsystemElement<?> subsystem = element.getSubsystem(this.namespaceUri);
        if (!subsystem.isEmpty()) {
            throw new UpdateFailedException("Subsystem " + this.namespaceUri + " configuration is not empty");
        }
        element.removeSubsystem(this.namespaceUri);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }
}

