/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.socket.AbstractInterfaceCriteriaElement;
import org.jboss.as.model.socket.InterfaceCriteria;
import org.jboss.as.services.net.NetworkInterfaceService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InterfaceElement
extends AbstractModelElement<InterfaceElement>
implements ServiceActivator {
    private static final long serialVersionUID = -5256526713311518506L;
    private final String name;
    private boolean anyLocalV4;
    private boolean anyLocalV6;
    private boolean anyLocal;
    private final NavigableMap<Element, AbstractInterfaceCriteriaElement<?>> interfaceCriteria = new TreeMap();

    public InterfaceElement(String name) {
        this.name = name;
    }

    public InterfaceElement(InterfaceElement fullySpecified) {
        this(fullySpecified.getName(), fullySpecified.getCriteriaElements());
        if (!fullySpecified.isFullySpecified()) {
            throw new IllegalArgumentException(fullySpecified + " is not fully specified");
        }
        this.setAnyLocal(fullySpecified.isAnyLocalAddress());
        this.setAnyLocalV4(fullySpecified.isAnyLocalV4Address());
        this.setAnyLocalV6(fullySpecified.isAnyLocalV6Address());
    }

    protected InterfaceElement(String name, List<AbstractInterfaceCriteriaElement<?>> criteriaList) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (criteriaList == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        this.name = name;
        for (AbstractInterfaceCriteriaElement<?> criteria : criteriaList) {
            this.interfaceCriteria.put(criteria.getElement(), criteria);
        }
    }

    @Override
    protected Class<InterfaceElement> getElementClass() {
        return InterfaceElement.class;
    }

    public String getName() {
        return this.name;
    }

    public InterfaceCriteria getInterfaceCriteria() {
        return new OverallInterfaceCriteria();
    }

    public boolean isAnyLocalAddress() {
        return this.anyLocal;
    }

    void setAnyLocal(boolean anyLocal) {
        if (anyLocal) {
            this.validateAnyLocalAllowed(Element.ANY_ADDRESS);
        }
        this.anyLocal = anyLocal;
    }

    public boolean isAnyLocalV4Address() {
        return this.anyLocalV4;
    }

    void setAnyLocalV4(boolean anyLocalV4) {
        if (anyLocalV4) {
            this.validateAnyLocalAllowed(Element.ANY_IPV4_ADDRESS);
        }
        this.anyLocalV4 = anyLocalV4;
    }

    public boolean isAnyLocalV6Address() {
        return this.anyLocalV6;
    }

    void setAnyLocalV6(boolean anyLocalV6) {
        if (anyLocalV6) {
            this.validateAnyLocalAllowed(Element.ANY_IPV6_ADDRESS);
        }
        this.anyLocalV6 = anyLocalV6;
    }

    protected void addCriteria(AbstractInterfaceCriteriaElement<?> criteria) {
        this.interfaceCriteria.put(criteria.getElement(), criteria);
    }

    public boolean isFullySpecified() {
        return this.anyLocal || this.anyLocalV4 || this.anyLocalV6 || this.interfaceCriteria.size() > 0;
    }

    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (this.anyLocal) {
            streamWriter.writeStartElement(Element.ANY_ADDRESS.getLocalName());
            streamWriter.writeEndElement();
        } else if (this.anyLocalV4) {
            streamWriter.writeStartElement(Element.ANY_IPV4_ADDRESS.getLocalName());
            streamWriter.writeEndElement();
        } else if (this.anyLocalV6) {
            streamWriter.writeStartElement(Element.ANY_IPV6_ADDRESS.getLocalName());
            streamWriter.writeEndElement();
        } else if (!this.interfaceCriteria.isEmpty()) {
            for (AbstractInterfaceCriteriaElement criteria : this.interfaceCriteria.values()) {
                streamWriter.writeStartElement(criteria.getElement().getLocalName());
                criteria.writeContent(streamWriter);
            }
        }
        streamWriter.writeEndElement();
    }

    public void activate(ServiceActivatorContext context) {
        context.getBatchBuilder().addService(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{this.name}), (Service)new NetworkInterfaceService(this.name, this.anyLocalV4, this.anyLocalV6, this.anyLocal, this.getInterfaceCriteria()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AbstractInterfaceCriteriaElement<?>> getCriteriaElements() {
        NavigableMap<Element, AbstractInterfaceCriteriaElement<?>> navigableMap = this.interfaceCriteria;
        synchronized (navigableMap) {
            return new ArrayList(this.interfaceCriteria.values());
        }
    }

    protected void validateAnyLocalAllowed(Element element) throws IllegalStateException {
        if (this.interfaceCriteria.size() > 0) {
            throw new IllegalStateException((Object)((Object)element) + " cannot be combined with " + this.interfaceCriteria.keySet().iterator().next());
        }
        this.validateNotAnyLocal(element);
    }

    private void validateNotAnyLocal(Element element) throws IllegalStateException {
        if (this.anyLocal) {
            throw new IllegalStateException((Object)((Object)element) + " cannot be combined with " + Element.ANY_ADDRESS.getLocalName());
        }
        if (this.anyLocalV4) {
            throw new IllegalStateException((Object)((Object)element) + " cannot be combined with " + Element.ANY_IPV4_ADDRESS.getLocalName());
        }
        if (this.anyLocalV6) {
            throw new IllegalStateException((Object)((Object)element) + " cannot be combined with " + Element.ANY_IPV6_ADDRESS.getLocalName());
        }
    }

    private class OverallInterfaceCriteria
    implements InterfaceCriteria {
        private static final long serialVersionUID = 2784447904647077246L;

        private OverallInterfaceCriteria() {
        }

        @Override
        public boolean isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
            for (AbstractInterfaceCriteriaElement criteria : InterfaceElement.this.interfaceCriteria.values()) {
                if (criteria.getInterfaceCriteria().isAcceptable(networkInterface, address)) continue;
                return false;
            }
            return true;
        }
    }
}

