/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.Namespace;
import org.jboss.as.model.ParseUtils;
import org.jboss.as.model.socket.AbstractInterfaceCriteriaElement;
import org.jboss.as.model.socket.CompoundCriteriaElement;
import org.jboss.as.model.socket.InetAddressMatchCriteriaElement;
import org.jboss.as.model.socket.InterfaceCriteria;
import org.jboss.as.model.socket.LinkLocalInterfaceCriteria;
import org.jboss.as.model.socket.LoopbackInterfaceCriteria;
import org.jboss.as.model.socket.NicCriteriaElement;
import org.jboss.as.model.socket.NicMatchCriteriaElement;
import org.jboss.as.model.socket.PointToPointInterfaceCriteria;
import org.jboss.as.model.socket.PublicAddressInterfaceCriteria;
import org.jboss.as.model.socket.SimpleCriteriaElement;
import org.jboss.as.model.socket.SiteLocalInterfaceCriteria;
import org.jboss.as.model.socket.SubnetMatchCriteriaElement;
import org.jboss.as.model.socket.SupportsMulticastInterfaceCriteria;
import org.jboss.as.model.socket.UpInterfaceCriteria;
import org.jboss.as.model.socket.VirtualInterfaceCriteria;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class InterfaceParsingUtils
implements XMLStreamConstants {
    public static final Set<Element> SIMPLE_CRITERIA = EnumSet.of(Element.INET_ADDRESS, new Element[]{Element.LOOPBACK, Element.LINK_LOCAL_ADDRESS, Element.MULTICAST, Element.NIC, Element.NIC_MATCH, Element.POINT_TO_POINT, Element.SITE_LOCAL_ADDRESS, Element.PUBLIC_ADDRESS, Element.SUBNET_MATCH, Element.UP, Element.VIRTUAL});
    public static final String SIMPLE_CRITERIA_STRING;
    public static final Set<Element> ALL_CRITERIA;
    public static final String ALL_CRITERIA_STRING;

    private static String criteriaToString(Set<Element> criteria) {
        StringBuilder b = new StringBuilder();
        Iterator<Element> iterator = criteria.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            b.append(element.getLocalName());
            if (!iterator.hasNext()) continue;
            b.append(", ");
        }
        return b.toString();
    }

    public static AbstractInterfaceCriteriaElement<?> parseSimpleInterfaceCriteria(XMLExtendedStreamReader reader, Element element) throws XMLStreamException {
        AbstractInterfaceCriteriaElement result = null;
        switch (element) {
            case INET_ADDRESS: {
                result = new InetAddressMatchCriteriaElement(reader);
                break;
            }
            case LINK_LOCAL_ADDRESS: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, LinkLocalInterfaceCriteria.INSTANCE);
                break;
            }
            case LOOPBACK: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, LoopbackInterfaceCriteria.INSTANCE);
                break;
            }
            case MULTICAST: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, SupportsMulticastInterfaceCriteria.INSTANCE);
                break;
            }
            case POINT_TO_POINT: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, PointToPointInterfaceCriteria.INSTANCE);
                break;
            }
            case PUBLIC_ADDRESS: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, PublicAddressInterfaceCriteria.INSTANCE);
                break;
            }
            case SITE_LOCAL_ADDRESS: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, SiteLocalInterfaceCriteria.INSTANCE);
                break;
            }
            case UP: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, UpInterfaceCriteria.INSTANCE);
                break;
            }
            case VIRTUAL: {
                result = InterfaceParsingUtils.createSimpleCriteria(reader, element, VirtualInterfaceCriteria.INSTANCE);
                break;
            }
            case NIC: {
                String name = ParseUtils.readStringAttributeElement(reader, Attribute.NAME.getLocalName());
                result = new NicCriteriaElement(name);
                break;
            }
            case NIC_MATCH: {
                result = InterfaceParsingUtils.createNicMatchCriteria(reader);
                break;
            }
            case SUBNET_MATCH: {
                result = InterfaceParsingUtils.createSubnetMatchCriteria(reader);
                break;
            }
            default: {
                throw new XMLStreamException("Unexpected element '" + reader.getName() + "' encountered", reader.getLocation());
            }
        }
        return result;
    }

    public static CompoundCriteriaElement createCompoundCriteria(XMLExtendedStreamReader reader, boolean isAny) throws XMLStreamException {
        HashMap interfaceCriteria = new HashMap();
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DOMAIN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    AbstractInterfaceCriteriaElement<?> aice = InterfaceParsingUtils.parseSimpleInterfaceCriteria(reader, element);
                    interfaceCriteria.put(aice.getElement(), aice);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (interfaceCriteria.isEmpty()) {
            throw InterfaceParsingUtils.missingCriteria(reader, SIMPLE_CRITERIA_STRING);
        }
        return new CompoundCriteriaElement(new HashSet(interfaceCriteria.values()), isAny);
    }

    static XMLStreamException missingCriteria(XMLExtendedStreamReader reader, String criteria) {
        return new XMLStreamException("At least one of the following elements must be supplied: " + criteria, reader.getLocation());
    }

    static NicMatchCriteriaElement createNicMatchCriteria(XMLExtendedStreamReader reader) throws XMLStreamException {
        Pattern pattern = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATTERN: {
                    try {
                        pattern = Pattern.compile(value);
                        continue block5;
                    }
                    catch (PatternSyntaxException e) {
                        throw new XMLStreamException("Invalid pattern " + value + " (" + e.getLocalizedMessage() + ")", reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (pattern == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PATTERN));
        }
        ParseUtils.requireNoContent(reader);
        return new NicMatchCriteriaElement(pattern);
    }

    static SubnetMatchCriteriaElement createSubnetMatchCriteria(XMLExtendedStreamReader reader) throws XMLStreamException {
        String value = null;
        byte[] net = null;
        int mask = -1;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    String[] split = null;
                    try {
                        split = value.split("/");
                        if (split.length != 2) {
                            throw new XMLStreamException("Invalid 'value' " + value + " -- must be of the form address/mask", reader.getLocation());
                        }
                        InetAddress addr = InetAddress.getByName(split[1]);
                        net = addr.getAddress();
                        mask = Integer.valueOf(split[1]);
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException("Invalid mask " + split[1] + " (" + e.getLocalizedMessage() + ")", reader.getLocation(), e);
                    }
                    catch (UnknownHostException e) {
                        throw new XMLStreamException("Invalid address " + split[1] + " (" + e.getLocalizedMessage() + ")", reader.getLocation(), e);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (net == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent(reader);
        return new SubnetMatchCriteriaElement(value, net, mask);
    }

    static SimpleCriteriaElement createSimpleCriteria(XMLExtendedStreamReader reader, Element type, InterfaceCriteria criteria) throws XMLStreamException {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria is null");
        }
        ParseUtils.requireNoAttributes(reader);
        ParseUtils.requireNoContent(reader);
        return new SimpleCriteriaElement(type, criteria);
    }

    private InterfaceParsingUtils() {
    }

    static {
        ALL_CRITERIA = EnumSet.copyOf(SIMPLE_CRITERIA);
        ALL_CRITERIA.add(Element.ANY);
        ALL_CRITERIA.add(Element.NOT);
        SIMPLE_CRITERIA_STRING = InterfaceParsingUtils.criteriaToString(SIMPLE_CRITERIA);
        ALL_CRITERIA_STRING = InterfaceParsingUtils.criteriaToString(ALL_CRITERIA);
    }
}

