/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.services.path;

import java.io.File;
import org.jboss.as.services.path.AbstractPathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class RelativePathService
extends AbstractPathService {
    private final String relativePath;
    private final InjectedValue<String> injectedPath = new InjectedValue();

    public static BatchServiceBuilder<String> addService(String name, String relativePath, String relativeTo, BatchBuilder batchBuilder) {
        return RelativePathService.addService(RelativePathService.pathNameOf(name), relativePath, relativeTo, batchBuilder);
    }

    public static BatchServiceBuilder<String> addService(ServiceName name, String relativePath, String relativeTo, BatchBuilder batchBuilder) {
        RelativePathService service = new RelativePathService(relativePath);
        return batchBuilder.addService(name, (Service)service).addDependency(RelativePathService.pathNameOf(relativeTo), String.class, service.injectedPath);
    }

    public RelativePathService(String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("relativePath is null");
        }
        if (relativePath.length() == 0) {
            throw new IllegalArgumentException("relativePath is empty");
        }
        if (relativePath.charAt(0) == '/') {
            if (relativePath.length() == 1) {
                throw new IllegalArgumentException("Invalid relativePath value '/'");
            }
            this.relativePath = relativePath.substring(1);
        } else {
            if (relativePath.indexOf(":\\") == 1) {
                throw new IllegalArgumentException(relativePath + " is a Windows absolute path");
            }
            this.relativePath = RelativePathService.isWindows() ? relativePath.replace("/", File.separator) : relativePath.replace("\\", File.separator);
        }
    }

    @Override
    protected String resolvePath() {
        String base = (String)this.injectedPath.getValue();
        base = base.endsWith(File.separator) ? base.substring(0, base.length() - 1) : base;
        String relative = this.relativePath.startsWith(File.separator) ? this.relativePath.substring(0, this.relativePath.length() - 1) : this.relativePath;
        return base + File.separatorChar + relative;
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

