/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.DispatcherInterceptor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class ComponentCreateService
implements Service<Component> {
    private final InjectedValue<DeploymentUnit> deploymentUnit = new InjectedValue();
    private final AbstractComponentConfiguration componentConfiguration;
    private AbstractComponent component;

    public ComponentCreateService(AbstractComponentConfiguration componentConfiguration) {
        this.componentConfiguration = componentConfiguration;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.component = this.componentConfiguration.constructComponent();
        ArrayList<Interceptor> rootInterceptors = new ArrayList<Interceptor>();
        SimpleInterceptorFactoryContext interceptorFactoryContext = new SimpleInterceptorFactoryContext();
        interceptorFactoryContext.getContextData().put(Component.class, this.component);
        for (InterceptorFactory factory : this.componentConfiguration.getComponentSystemInterceptorFactories()) {
            rootInterceptors.add(factory.create((InterceptorFactoryContext)interceptorFactoryContext));
        }
        rootInterceptors.add(DispatcherInterceptor.INSTANCE);
        this.component.setComponentInterceptor(Interceptors.getChainedInterceptor(rootInterceptors));
    }

    public synchronized void stop(StopContext context) {
        this.component = null;
    }

    public synchronized Component getValue() throws IllegalStateException, IllegalArgumentException {
        AbstractComponent component = this.component;
        if (component == null) {
            throw new IllegalStateException("Service not started");
        }
        return component;
    }

    public Injector<DeploymentUnit> getDeploymentUnitInjector() {
        return this.deploymentUnit;
    }

    public AbstractComponentConfiguration getComponentConfiguration() {
        return this.componentConfiguration;
    }
}

