/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.LazyBindingSourceDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class ComponentLazyBindingSourceHandler
implements LazyBindingSourceDescription.LazyBingingSourceDescriptionHandler {
    static ComponentLazyBindingSourceHandler INSTANCE = new ComponentLazyBindingSourceHandler();

    private ComponentLazyBindingSourceHandler() {
    }

    @Override
    public boolean getResourceValue(AbstractComponentDescription componentDescription, BindingDescription referenceDescription, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        Set<AbstractComponentDescription> componentDescriptions;
        String bindingType = referenceDescription.getBindingType();
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationComponentDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        if (applicationComponentDescription != null && (componentDescriptions = applicationComponentDescription.getComponentsForViewName(bindingType)) != null && !componentDescriptions.isEmpty()) {
            if (componentDescriptions.size() > 1) {
                throw new IllegalArgumentException("BindingDescription source can not be resolved.  Ambiguous required view [" + bindingType + "]");
            }
            AbstractComponentDescription targetComponentDescription = componentDescriptions.iterator().next();
            ServiceName beanServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{targetComponentDescription.getComponentName()}).append(new String[]{"VIEW"}).append(new String[]{bindingType});
            serviceBuilder.addDependency(beanServiceName, ManagedReferenceFactory.class, injector);
            return true;
        }
        return false;
    }
}

