/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.InterceptorMethodDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class LifecycleAnnotationParsingProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName POST_CONSTRUCT_ANNOTATION = DotName.createSimple((String)PostConstruct.class.getName());
    private static final DotName PRE_DESTROY_ANNOTATION = DotName.createSimple((String)PreDestroy.class.getName());

    @Override
    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        this.processClass(index, componentConfiguration, DotName.createSimple((String)componentConfiguration.getComponentClassName()), componentConfiguration.getComponentClassName(), true);
        for (InterceptorDescription description : componentConfiguration.getClassInterceptors()) {
            this.processClass(index, componentConfiguration, DotName.createSimple((String)description.getInterceptorClassName()), componentConfiguration.getComponentClassName(), false);
        }
    }

    private void processClass(CompositeIndex index, AbstractComponentDescription componentDescription, DotName className, String actualClassName, boolean declaredOnTargetClass) {
        InterceptorMethodDescription preDestroyMethod;
        InterceptorMethodDescription postConstructMethod;
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            return;
        }
        DotName superName = classInfo.superName();
        if (superName != null) {
            this.processClass(index, componentDescription, superName, actualClassName, declaredOnTargetClass);
        }
        if ((postConstructMethod = this.getLifeCycle(classInfo, actualClassName, POST_CONSTRUCT_ANNOTATION, declaredOnTargetClass)) != null) {
            componentDescription.addPostConstructMethod(postConstructMethod);
        }
        if ((preDestroyMethod = this.getLifeCycle(classInfo, actualClassName, PRE_DESTROY_ANNOTATION, declaredOnTargetClass)) != null) {
            componentDescription.addPreDestroyMethod(preDestroyMethod);
        }
    }

    private InterceptorMethodDescription getLifeCycle(ClassInfo classInfo, String actualClass, DotName annotationType, boolean declaredOnTargetClass) {
        if (classInfo == null) {
            return null;
        }
        Map classAnnotations = classInfo.annotations();
        List instances = (List)classAnnotations.get(annotationType);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        if (instances.size() > 1) {
            throw new IllegalArgumentException("Only one method may be annotated with " + annotationType + " per bean.");
        }
        AnnotationTarget target = ((AnnotationInstance)instances.get(0)).target();
        if (!(target instanceof MethodInfo)) {
            throw new IllegalArgumentException(annotationType + " is only valid on method targets.");
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        Type[] args = methodInfo.args();
        if (declaredOnTargetClass) {
            if (args.length == 0) {
                return InterceptorMethodDescription.create(classInfo.name().toString(), actualClass, methodInfo, declaredOnTargetClass);
            }
            throw new IllegalArgumentException("Invalid number of arguments for method " + methodInfo.name() + " annotated with " + annotationType + " on class " + classInfo.name());
        }
        if (args.length == 1 && args[0].name().toString().equals(InvocationContext.class.getName())) {
            return InterceptorMethodDescription.create(classInfo.name().toString(), actualClass, methodInfo, declaredOnTargetClass);
        }
        throw new IllegalArgumentException("Invalid signature for method " + methodInfo.name() + " annotated with " + annotationType + " on class " + classInfo.name() + ", signature must be void methodName(InvocationContext ctx)");
    }
}

