/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class LookupBindingSourceDescription
extends BindingSourceDescription {
    private final String lookupName;

    public LookupBindingSourceDescription(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public void getResourceValue(AbstractComponentDescription componentDescription, BindingDescription bindingDescription, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        if (!this.lookupName.startsWith("java:")) {
            throw new RuntimeException("lookup name " + this.lookupName + " not supported, lookup in @Resource annotation must start with java in " + componentDescription.getComponentClassName());
        }
        String compName = componentDescription.getNamingMode() == ComponentNamingMode.CREATE ? componentDescription.getComponentName() : componentDescription.getModuleName();
        String moduleName = componentDescription.getModuleName();
        String appName = componentDescription.getApplicationName();
        ServiceName sourceServiceName = ContextNames.serviceNameOfContext(appName, moduleName, compName, this.lookupName);
        serviceBuilder.addDependency(sourceServiceName, ManagedReferenceFactory.class, injector);
    }
}

