/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;

public final class ProxyInvocationHandler
implements InvocationHandler {
    private final Interceptor interceptor;
    private volatile Map<Class<?>, Object> initialPrivateData = Collections.emptyMap();

    public ProxyInvocationHandler(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public ProxyInvocationHandler(InterceptorFactory interceptorFactory) {
        this.interceptor = interceptorFactory.create((InterceptorFactoryContext)new SimpleInterceptorFactoryContext());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InterceptorContext context = new InterceptorContext();
        Map<Class<?>, Object> privateData = this.initialPrivateData;
        for (Map.Entry<Class<?>, Object> entry : privateData.entrySet()) {
            Class<?> key = entry.getKey();
            Object value = entry.getValue();
            ProxyInvocationHandler.putPrivate(context, key, value);
        }
        context.putPrivateData(Object.class, proxy);
        context.setParameters(args);
        context.setMethod(method);
        return this.interceptor.processInvocation(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T putPrivateData(Class<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        ProxyInvocationHandler proxyInvocationHandler = this;
        synchronized (proxyInvocationHandler) {
            IdentityHashMap newMap = new IdentityHashMap(this.initialPrivateData);
            if (value == null) {
                T t = key.cast(newMap.remove(key));
                return t;
                finally {
                    this.initialPrivateData = newMap;
                }
            }
            T t = key.cast(newMap.put(key, value));
            return t;
            finally {
                this.initialPrivateData = newMap;
            }
        }
    }

    public <T> T getPrivateData(Class<T> key) {
        return key.cast(this.initialPrivateData.get(key));
    }

    private static <T> void putPrivate(InterceptorContext context, Class<T> key, Object value) {
        context.putPrivateData(key, key.cast(value));
    }
}

