/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.List;
import javax.annotation.ManagedBean;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.vfs.VirtualFile;

public class EjbJarDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName STATELESS = DotName.createSimple((String)"javax.ejb.Stateless");
    private static final DotName STATEFULL = DotName.createSimple((String)"javax.ejb.Stateful");
    private static final DotName MESSAGE_DRIVEN = DotName.createSimple((String)"javax.ejb.MessageDriven");
    private static final DotName SINGLETON = DotName.createSimple((String)"javax.ejb.Singleton");
    private static final DotName MANAGED_BEAN_ANNOTATION_NAME = DotName.createSimple((String)ManagedBean.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        List potentialSubDeployments = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : potentialSubDeployments) {
            if (ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot)) continue;
            VirtualFile ejbJarFile = resourceRoot.getRoot().getChild("META-INF/ejb-jar.xml");
            if (ejbJarFile.exists()) {
                SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
                ModuleRootMarker.mark((ResourceRoot)resourceRoot);
                continue;
            }
            Index index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null || index.getAnnotations(STATEFULL).isEmpty() && index.getAnnotations(STATELESS).isEmpty() && index.getAnnotations(MESSAGE_DRIVEN).isEmpty() && index.getAnnotations(SINGLETON).isEmpty() && index.getAnnotations(MANAGED_BEAN_ANNOTATION_NAME).isEmpty()) continue;
            SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
            ModuleRootMarker.mark((ResourceRoot)resourceRoot);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

