/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.management.JndiViewExtension;
import org.jboss.as.naming.management.JndiViewExtensionContext;
import org.jboss.as.naming.management.JndiViewExtensionRegistry;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class EEJndiViewExtension
implements JndiViewExtension,
Service<Void> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jndi-view", "extension", "ee"});
    private final InjectedValue<JndiViewExtensionRegistry> registry = new InjectedValue();

    public synchronized void start(StartContext startContext) throws StartException {
        ((JndiViewExtensionRegistry)this.registry.getValue()).addExtension((JndiViewExtension)this);
    }

    public synchronized void stop(StopContext stopContext) {
        ((JndiViewExtensionRegistry)this.registry.getValue()).removeExtension((JndiViewExtension)this);
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void execute(JndiViewExtensionContext context) throws OperationFailedException {
        ModelNode applicationsNode = context.getResult().get("applications");
        ServiceRegistry serviceRegistry = context.getOperationContext().getServiceRegistry(false);
        Set deploymentResource = context.getOperationContext().getRootResource().getChildren("deployment");
        for (Resource.ResourceEntry entry : deploymentResource) {
            ServiceController deploymentUnitServiceController = serviceRegistry.getService(ServiceName.JBOSS.append(new String[]{"deployment", "unit", entry.getName()}));
            if (deploymentUnitServiceController == null) continue;
            ModelNode deploymentNode = applicationsNode.get(entry.getName());
            DeploymentUnit deploymentUnit = (DeploymentUnit)DeploymentUnit.class.cast(deploymentUnitServiceController.getValue());
            String appName = this.cleanName(deploymentUnit.getName());
            ServiceName appContextName = ContextNames.contextServiceNameOfApplication((String)appName);
            ServiceController appContextController = serviceRegistry.getService(appContextName);
            if (appContextController != null) {
                NamingStore appStore = (NamingStore)NamingStore.class.cast(appContextController.getValue());
                try {
                    context.addEntries(deploymentNode.get("java:app"), (Context)new NamingContext(appStore, null));
                }
                catch (NamingException e) {
                    throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to read java:app entries for application [" + appName + "]"));
                }
            }
            if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
                List roots = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS);
                if (roots == null) continue;
                for (ResourceRoot root : roots) {
                    if (!SubDeploymentMarker.isSubDeployment((ResourceRoot)root)) continue;
                    ResourceRoot parentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
                    String relativePath = root.getRoot().getPathNameRelativeTo(parentRoot.getRoot());
                    ServiceName subDeploymentServiceName = Services.deploymentUnitName((String)deploymentUnit.getName(), (String)relativePath);
                    ServiceController subDeploymentController = serviceRegistry.getService(subDeploymentServiceName);
                    if (subDeploymentController == null) continue;
                    DeploymentUnit subDeploymentUnit = (DeploymentUnit)DeploymentUnit.class.cast(subDeploymentController.getValue());
                    this.handleModule(context, subDeploymentUnit, deploymentNode.get("modules"), serviceRegistry);
                }
                continue;
            }
            this.handleModule(context, deploymentUnit, deploymentNode.get("modules"), serviceRegistry);
        }
    }

    private void handleModule(JndiViewExtensionContext context, DeploymentUnit deploymentUnit, ModelNode modulesNode, ServiceRegistry serviceRegistry) throws OperationFailedException {
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String appName = moduleDescription.getApplicationName();
        String moduleName = moduleDescription.getModuleName();
        ModelNode moduleNode = modulesNode.get(moduleDescription.getModuleName());
        ServiceName moduleContextName = ContextNames.contextServiceNameOfModule((String)appName, (String)moduleName);
        ServiceController moduleContextController = serviceRegistry.getService(moduleContextName);
        if (moduleContextController != null) {
            NamingStore moduleStore = (NamingStore)NamingStore.class.cast(moduleContextController.getValue());
            try {
                context.addEntries(moduleNode.get("java:module"), (Context)new NamingContext(moduleStore, null));
            }
            catch (NamingException e) {
                throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to read java:module entries for module [" + appName + ", " + moduleName + "]"));
            }
            Collection<ComponentDescription> componentDescriptions = moduleDescription.getComponentDescriptions();
            for (ComponentDescription componentDescription : componentDescriptions) {
                String componentName = componentDescription.getComponentName();
                ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)appName, (String)moduleName, (String)componentName);
                ServiceController compContextController = serviceRegistry.getService(compContextServiceName);
                if (compContextController == null) continue;
                ModelNode componentNode = moduleNode.get("components").get(componentName);
                NamingStore compStore = (NamingStore)NamingStore.class.cast(compContextController.getValue());
                try {
                    context.addEntries(componentNode.get("java:comp"), (Context)new NamingContext(compStore, null));
                }
                catch (NamingException e) {
                    throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to read java:comp entries for component [" + appName + ", " + moduleName + ", " + componentName + "]"));
                }
            }
        }
    }

    private String cleanName(String name) {
        String cleaned = name.endsWith(".war") || name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".rar") ? name.substring(0, name.length() - 4) : name;
        return cleaned;
    }

    public Injector<JndiViewExtensionRegistry> getRegistryInjector() {
        return this.registry;
    }
}

