/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.EeSubsystemAdd;
import org.jboss.as.ee.subsystem.EeSubsystemProviders;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class EeExtension
implements Extension {
    public static final String NAMESPACE = "urn:jboss:domain:ee:1.0";
    private static final String SUBSYSTEM_NAME = "ee";
    private static final EESubsystemParser parser = new EESubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(EeSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)EeSubsystemAdd.INSTANCE, EeSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)EESubsystemDescribeHandler.INSTANCE, (DescriptionProvider)EESubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE, (XMLElementReader)parser);
    }

    static ModelNode createEESubSystemAddOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class EESubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final EESubsystemDescribeHandler INSTANCE = new EESubsystemDescribeHandler();

        private EESubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode op = EeExtension.createEESubSystemAddOperation();
            if (model.hasDefined("global-modules")) {
                op.get("global-modules").set(model.get("global-modules"));
            }
            if (model.hasDefined(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName())) {
                op.get(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName()).set(model.get(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName()));
            }
            context.getResult().add(op);
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class EESubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        EESubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(EeExtension.NAMESPACE, false);
            ModelNode eeSubSystem = context.getModelNode();
            if (eeSubSystem.hasDefined(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName())) {
                writer.writeStartElement(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName());
                ModelNode earSubDeploymentsIsolated = eeSubSystem.get(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName());
                writer.writeCharacters(earSubDeploymentsIsolated.asString());
                writer.writeEndElement();
            }
            if (eeSubSystem.hasDefined("global-modules")) {
                writer.writeStartElement(Element.GLOBAL_MODULES.getLocalName());
                ModelNode globalModules = eeSubSystem.get("global-modules");
                for (ModelNode module : globalModules.asList()) {
                    writer.writeStartElement(Element.MODULE.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), module.get("name").asString());
                    writer.writeAttribute(Attribute.SLOT.getLocalName(), module.get("slot").asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode eeSubSystem = EeExtension.createEESubSystemAddOperation();
            list.add(eeSubSystem);
            EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case EE_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!encountered.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case GLOBAL_MODULES: {
                                ModelNode model = EESubsystemParser.parseGlobalModules(reader);
                                eeSubSystem.get("global-modules").set(model);
                                continue block7;
                            }
                            case EAR_SUBDEPLOYMENTS_ISOLATED: {
                                Boolean earSubDeploymentsIsolated = EESubsystemParser.parseEarSubDeploymentsIsolatedElement(reader);
                                if (earSubDeploymentsIsolated == null) continue block7;
                                eeSubSystem.get(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName()).set(earSubDeploymentsIsolated.booleanValue());
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        static ModelNode parseGlobalModules(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode globalModules = new ModelNode();
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Element.forName(reader.getLocalName())) {
                    case MODULE: {
                        int count = reader.getAttributeCount();
                        String name = null;
                        String slot = null;
                        block8: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            String value = reader.getAttributeValue(i);
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    if (name != null) {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                    name = value;
                                    continue block8;
                                }
                                case SLOT: {
                                    if (slot != null) {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                    slot = value;
                                    continue block8;
                                }
                                default: {
                                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
                        }
                        if (slot == null) {
                            slot = "main";
                        }
                        ModelNode module = new ModelNode();
                        module.get("name").set(name);
                        module.get("slot").set(slot);
                        globalModules.add(module);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                }
                ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return globalModules;
        }

        static Boolean parseEarSubDeploymentsIsolatedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            String value = reader.getElementText();
            if (value == null || value.trim().isEmpty()) {
                throw new XMLStreamException("Invalid value: " + value + " for '" + (Object)((Object)Element.EAR_SUBDEPLOYMENTS_ISOLATED) + "' element", reader.getLocation());
            }
            return Boolean.parseBoolean(value.trim());
        }
    }
}

