/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

final class ManagedReferenceFieldInjectionInterceptor
implements Interceptor {
    private final AtomicReference<ManagedReference> targetReference;
    private final AtomicReference<ManagedReference> valueReference;
    private final ManagedReferenceFactory factory;
    private final Field field;

    ManagedReferenceFieldInjectionInterceptor(AtomicReference<ManagedReference> targetReference, AtomicReference<ManagedReference> valueReference, ManagedReferenceFactory factory, Field field) {
        this.targetReference = targetReference;
        this.valueReference = valueReference;
        this.factory = factory;
        this.field = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        Object target = this.targetReference.get().getInstance();
        if (target == null) {
            throw new IllegalStateException("No injection target found");
        }
        ManagedReference reference = this.factory.getReference();
        boolean ok = false;
        try {
            this.valueReference.set(reference);
            this.field.set(target, reference.getInstance());
            Object result = context.proceed();
            ok = true;
            Object object = result;
            return object;
        }
        finally {
            if (!ok) {
                this.valueReference.set(null);
                reference.release();
            }
        }
    }
}

