/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InterceptorsAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName INTERCEPTORS_ANNOTATION_NAME = DotName.createSimple((String)Interceptors.class.getName());
    private static final DotName EXCLUDE_DEFAULT_ANNOTATION_NAME = DotName.createSimple((String)ExcludeDefaultInterceptors.class.getName());
    private static final DotName EXCLUDE_CLASS_ANNOTATION_NAME = DotName.createSimple((String)ExcludeClassInterceptors.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        List interceptors = index.getAnnotations(INTERCEPTORS_ANNOTATION_NAME);
        for (AnnotationInstance annotation : interceptors) {
            this.processInterceptors(eeModuleDescription, annotation, index);
        }
        List excludeDefaults = index.getAnnotations(EXCLUDE_DEFAULT_ANNOTATION_NAME);
        for (AnnotationInstance annotation : excludeDefaults) {
            this.processExcludeDefault(eeModuleDescription, annotation, index);
        }
        List excludeClasses = index.getAnnotations(EXCLUDE_CLASS_ANNOTATION_NAME);
        for (AnnotationInstance annotation : excludeClasses) {
            this.processExcludeClass(eeModuleDescription, annotation, index);
        }
    }

    private void processInterceptors(EEModuleDescription eeModuleDescription, AnnotationInstance annotation, CompositeIndex index) throws DeploymentUnitProcessingException {
        AnnotationTarget target = annotation.target();
        if (target instanceof MethodInfo) {
            this.processMethodInterceptor(eeModuleDescription, (MethodInfo)MethodInfo.class.cast(target), annotation, index);
        } else if (target instanceof ClassInfo) {
            this.processClassInterceptor(eeModuleDescription, (ClassInfo)ClassInfo.class.cast(target), annotation, index);
        } else {
            throw new DeploymentUnitProcessingException("@Interceptors annotation is only allowed on methods and classes");
        }
    }

    private void processMethodInterceptor(EEModuleDescription eeModuleDescription, MethodInfo methodInfo, AnnotationInstance annotation, CompositeIndex index) {
        Collection<ComponentDescription> components = this.getApplicableComponents(index, methodInfo.declaringClass(), eeModuleDescription);
        AnnotationValue value = annotation.value();
        if (value != null) {
            for (Type interceptorClass : value.asClassArray()) {
                for (ComponentDescription component : components) {
                    component.addMethodInterceptor(InterceptorsAnnotationParsingProcessor.methodIdentifierFromMethodInfo(methodInfo), new InterceptorDescription(interceptorClass.name().toString()));
                }
            }
        }
    }

    private void processClassInterceptor(EEModuleDescription eeModuleDescription, ClassInfo classInfo, AnnotationInstance annotation, CompositeIndex index) {
        Collection<ComponentDescription> components = this.getApplicableComponents(index, classInfo, eeModuleDescription);
        AnnotationValue value = annotation.value();
        if (value != null) {
            for (Type interceptorClass : value.asClassArray()) {
                for (ComponentDescription component : components) {
                    component.addClassInterceptor(new InterceptorDescription(interceptorClass.name().toString()));
                }
            }
        }
    }

    private void processExcludeDefault(EEModuleDescription eeModuleDescription, AnnotationInstance annotation, CompositeIndex index) throws DeploymentUnitProcessingException {
        AnnotationTarget target = annotation.target();
        if (target instanceof MethodInfo) {
            this.processMethodExcludeDefault(eeModuleDescription, (MethodInfo)MethodInfo.class.cast(target), index);
        } else if (target instanceof ClassInfo) {
            this.processClassExcludeDefault(eeModuleDescription, (ClassInfo)ClassInfo.class.cast(target), index);
        } else {
            throw new DeploymentUnitProcessingException("@ExcludeDefaultInterceptors annotation is only allowed on methods and classes");
        }
    }

    private void processClassExcludeDefault(EEModuleDescription eeModuleDescription, ClassInfo classInfo, CompositeIndex index) {
        Collection<ComponentDescription> components = this.getApplicableComponents(index, classInfo, eeModuleDescription);
        for (ComponentDescription component : components) {
            component.setExcludeDefaultInterceptors(true);
        }
    }

    private void processMethodExcludeDefault(EEModuleDescription eeModuleDescription, MethodInfo methodInfo, CompositeIndex index) {
        Collection<ComponentDescription> components = this.getApplicableComponents(index, methodInfo.declaringClass(), eeModuleDescription);
        for (ComponentDescription component : components) {
            component.excludeDefaultInterceptors(InterceptorsAnnotationParsingProcessor.methodIdentifierFromMethodInfo(methodInfo));
        }
    }

    private void processExcludeClass(EEModuleDescription eeModuleDescription, AnnotationInstance annotation, CompositeIndex index) throws DeploymentUnitProcessingException {
        AnnotationTarget target = annotation.target();
        if (target instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
            Collection<ComponentDescription> components = this.getApplicableComponents(index, methodInfo.declaringClass(), eeModuleDescription);
            for (ComponentDescription component : components) {
                component.excludeClassInterceptors(InterceptorsAnnotationParsingProcessor.methodIdentifierFromMethodInfo(methodInfo));
            }
        } else {
            throw new DeploymentUnitProcessingException("@ExcludeDefaultInterceptors annotation is only allowed on methods");
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static MethodIdentifier methodIdentifierFromMethodInfo(MethodInfo methodInfo) {
        String[] argTypes = new String[methodInfo.args().length];
        int i = 0;
        for (Type argType : methodInfo.args()) {
            argTypes[i++] = argType.name().toString();
        }
        return MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])argTypes);
    }

    private Collection<ComponentDescription> getApplicableComponents(CompositeIndex index, ClassInfo klass, EEModuleDescription eeModuleDescription) {
        HashSet<ComponentDescription> componentDescriptions = new HashSet<ComponentDescription>();
        List<ComponentDescription> descriptions = eeModuleDescription.getComponentsByClassName(klass.name().toString());
        if (!descriptions.isEmpty()) {
            componentDescriptions.addAll(descriptions);
        } else {
            componentDescriptions.addAll(this.getKnownSubClassComponents(index, klass, eeModuleDescription));
        }
        return componentDescriptions;
    }

    private Collection<ComponentDescription> getKnownSubClassComponents(CompositeIndex index, ClassInfo superClass, EEModuleDescription eeModuleDescription) {
        Set subClasses = index.getAllKnownSubclasses(superClass.name());
        if (subClasses == null || subClasses.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ComponentDescription> components = new HashSet<ComponentDescription>();
        for (ClassInfo subClass : subClasses) {
            List<ComponentDescription> componentDescriptions = eeModuleDescription.getComponentsByClassName(subClass.name().toString());
            components.addAll(componentDescriptions);
        }
        return components;
    }
}

