/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;

public class MethodAnnotationAggregator {
    private static final Logger logger = Logger.getLogger(MethodAnnotationAggregator.class);

    public static <A extends Annotation, T> RuntimeAnnotationInformation<T> runtimeAnnotationInformation(Class<?> componentClass, EEApplicationClasses applicationClasses, DeploymentReflectionIndex index, Class<A> annotationType) {
        HashSet<MethodIdentifier> methodIdentifiers = new HashSet<MethodIdentifier>();
        HashMap methods = new HashMap();
        HashMap classAnnotations = new HashMap();
        for (Class<?> c = componentClass; c != null && c != Object.class; c = c.getSuperclass()) {
            ClassAnnotationInformation annotationData;
            ClassReflectionIndex classIndex = index.getClassIndex(c);
            EEModuleClassDescription description = applicationClasses.getClassByName(c.getName());
            if (description != null && (annotationData = description.getAnnotationInformation(annotationType)) != null) {
                if (!annotationData.getClassLevelAnnotations().isEmpty()) {
                    classAnnotations.put(c.getName(), annotationData.getClassLevelAnnotations());
                }
                for (Map.Entry entry : annotationData.getMethodLevelAnnotations().entrySet()) {
                    Method method = classIndex.getMethod(entry.getKey());
                    if (method != null) {
                        if (!Modifier.isPrivate(method.getModifiers()) && methodIdentifiers.contains(entry.getKey())) continue;
                        methods.put(method, entry.getValue());
                        continue;
                    }
                    throw new RuntimeException("Could not resolve method " + entry.getKey() + " on class " + c + " with annotations " + entry.getValue());
                }
            }
            for (Method method : classIndex.getMethods()) {
                if (Modifier.isPrivate(method.getModifiers())) continue;
                methodIdentifiers.add(MethodIdentifier.getIdentifierForMethod((Method)method));
            }
        }
        return new RuntimeAnnotationInformation(classAnnotations, methods);
    }

    public static <A extends Annotation, T> Set<Method> runtimeAnnotationPresent(Class<?> componentClass, EEApplicationClasses applicationClasses, DeploymentReflectionIndex index, Class<A> annotationType) {
        RuntimeAnnotationInformation<T> result = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, applicationClasses, index, annotationType);
        return result.getMethodAnnotations().keySet();
    }
}

