/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.jar.Manifest;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;

public final class EEDistinctNameProcessor
implements DeploymentUnitProcessor {
    public static final String DISTINCT_NAME = "Distinct-Name";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription module = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        if (module == null) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            EEModuleDescription parentDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            module.setDistinctName(parentDescription.getDistinctName());
            return;
        }
        Manifest manifest = (Manifest)deploymentRoot.getAttachment(org.jboss.as.server.deployment.Attachments.MANIFEST);
        if (manifest == null) {
            return;
        }
        String name = manifest.getMainAttributes().getValue(DISTINCT_NAME);
        if (name == null) {
            return;
        }
        if (!name.trim().isEmpty()) {
            module.setDistinctName(name.trim());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

