/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.CircularDependencyException;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ModuleJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
        if (moduleConfiguration == null) {
            return;
        }
        Set dependencies = (Set)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        HashMap<ServiceName, BindingConfiguration> deploymentDescriptorBindings = new HashMap<ServiceName, BindingConfiguration>();
        IntHolder moduleCount = new IntHolder();
        List<BindingConfiguration> bindingConfigurations = eeModuleDescription.getBindingConfigurations();
        ServiceName moduleOwnerName = deploymentUnit.getServiceName().append(new String[]{"module"}).append(new String[]{moduleConfiguration.getApplicationName()}).append(new String[]{moduleConfiguration.getModuleName()});
        for (BindingConfiguration binding : bindingConfigurations) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
            deploymentDescriptorBindings.put(bindInfo.getBinderServiceName(), binding);
            this.addJndiBinding(moduleConfiguration, binding, phaseContext, bindInfo.getBinderServiceName(), moduleOwnerName, moduleCount, dependencies);
        }
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            for (BindingConfiguration binding : componentConfiguration.getComponentDescription().getBindingConfigurations()) {
                boolean compBinding;
                String bindingName = binding.getName();
                boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                if (componentConfiguration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE && compBinding) continue;
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                deploymentDescriptorBindings.put(bindInfo.getBinderServiceName(), binding);
                this.addJndiBinding(moduleConfiguration, binding, phaseContext, bindInfo.getBinderServiceName(), moduleOwnerName, moduleCount, dependencies);
            }
        }
        HashSet<String> handledClasses = new HashSet<String>();
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            HashSet classConfigurations = new HashSet();
            classConfigurations.add(componentConfiguration.getComponentClass());
            for (InterceptorDescription interceptor : componentConfiguration.getComponentDescription().getAllInterceptors()) {
                try {
                    ClassIndex interceptorClass = classIndex.classIndex(interceptor.getInterceptorClassName());
                    classConfigurations.add(interceptorClass.getModuleClass());
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoadInterceptor(e, interceptor.getInterceptorClassName(), componentConfiguration.getComponentClass());
                }
            }
            this.processClassConfigurations(phaseContext, applicationClasses, moduleConfiguration, deploymentDescriptorBindings, handledClasses, componentConfiguration.getComponentDescription().getNamingMode(), classConfigurations, componentConfiguration.getComponentName(), moduleOwnerName, moduleCount, dependencies);
        }
    }

    private void processClassConfigurations(final DeploymentPhaseContext phaseContext, EEApplicationClasses applicationClasses, final EEModuleConfiguration moduleConfiguration, final Map<ServiceName, BindingConfiguration> deploymentDescriptorBindings, final Set<String> handledClasses, final ComponentNamingMode namingMode, Set<Class<?>> classes, final String componentName, final ServiceName ownerName, final IntHolder handleCount, final Set<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        for (Class<?> clazz : classes) {
            new ClassDescriptionTraversal(clazz, applicationClasses){

                @Override
                protected void handle(Class<?> currentClass, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    if (classDescription == null) {
                        return;
                    }
                    if (classDescription.isInvalid()) {
                        throw EeMessages.MESSAGES.componentClassHasErrors(classDescription.getClassName(), componentName, classDescription.getInvalidMessage());
                    }
                    if (handledClasses.contains(classDescription.getClassName())) {
                        return;
                    }
                    handledClasses.add(classDescription.getClassName());
                    if (!MetadataCompleteMarker.isMetadataComplete(phaseContext.getDeploymentUnit())) {
                        HashSet<BindingConfiguration> classLevelBindings = new HashSet<BindingConfiguration>(classDescription.getBindingConfigurations());
                        for (BindingConfiguration binding : classLevelBindings) {
                            boolean compBinding;
                            String bindingName = binding.getName();
                            boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                            if (namingMode == ComponentNamingMode.CREATE && compBinding) continue;
                            ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                            EeLogger.ROOT_LOGGER.tracef("Binding %s using service %s", binding.getName(), bindInfo.getBinderServiceName());
                            if (deploymentDescriptorBindings.containsKey(bindInfo.getBinderServiceName())) continue;
                            ModuleJndiBindingProcessor.this.addJndiBinding(moduleConfiguration, binding, phaseContext, bindInfo.getBinderServiceName(), ownerName, handleCount, dependencies);
                        }
                    }
                }
            }.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addJndiBinding(EEModuleConfiguration module, BindingConfiguration bindingConfiguration, DeploymentPhaseContext phaseContext, ServiceName serviceName, ServiceName ownerName, IntHolder handleCount, Set<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        BinderService service;
        String bindingName = bindingConfiguration.getName().startsWith("java:") ? bindingConfiguration.getName() : "java:module/env/" + bindingConfiguration.getName();
        ServiceVerificationHandler serviceVerificationHandler = (ServiceVerificationHandler)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.SERVICE_VERIFICATION_HANDLER);
        InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(true, module.getModuleName(), module.getModuleName(), module.getApplicationName());
        if (bindingName == null) throw EeMessages.MESSAGES.nullBindingName(bindingConfiguration);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)module.getApplicationName(), (String)module.getModuleName(), (String)module.getModuleName(), (boolean)false, (String)bindingName);
        if (bindingName.startsWith("java:comp") || bindingName.startsWith("java:module") || bindingName.startsWith("java:app")) {
            try {
                BinderService service2 = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
                dependencies.add(bindInfo.getBinderServiceName());
                ServiceBuilder serviceBuilder = phaseContext.getServiceTarget().addService(bindInfo.getBinderServiceName(), (Service)service2);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service2.getManagedObjectInjector());
                serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, service2.getNamingStoreInjector());
                serviceBuilder.install();
                return;
            }
            catch (DuplicateServiceException e) {
                ServiceController registered = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
                if (registered == null) {
                    throw e;
                }
                BinderService service3 = (BinderService)registered.getService();
                if (service3.getSource().equals(bindingConfiguration.getSource())) return;
                throw EeMessages.MESSAGES.conflictingBinding(bindingName, bindingConfiguration.getSource());
            }
            catch (CircularDependencyException e) {
                throw EeMessages.MESSAGES.circularDependency(bindingName);
            }
        }
        ServiceController controller = null;
        try {
            service = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
            dependencies.add(bindInfo.getBinderServiceName());
            ServiceBuilder serviceBuilder = CurrentServiceContainer.getServiceContainer().addService(bindInfo.getBinderServiceName(), (Service)service);
            bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
            serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, service.getNamingStoreInjector());
            serviceBuilder.addListener((ServiceListener)serviceVerificationHandler);
            controller = serviceBuilder.install();
            service.acquire();
        }
        catch (DuplicateServiceException e) {
            controller = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
            if (controller == null) {
                throw e;
            }
            service = (BinderService)controller.getService();
            if (!service.getSource().equals(bindingConfiguration.getSource())) {
                throw EeMessages.MESSAGES.conflictingBinding(bindingName, bindingConfiguration.getSource());
            }
            service.acquire();
        }
        ServiceController unitService = CurrentServiceContainer.getServiceContainer().getService(phaseContext.getDeploymentUnit().getServiceName());
        BinderService binderService = service;
        unitService.addListener(new BinderReleaseListener(binderService));
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class BinderReleaseListener<T>
    extends AbstractServiceListener<T> {
        private final BinderService binderService;

        public BinderReleaseListener(BinderService binderService) {
            this.binderService = binderService;
        }

        public void listenerAdded(ServiceController<? extends T> serviceController) {
            if (serviceController.getState() == ServiceController.State.DOWN || serviceController.getState() == ServiceController.State.STOPPING) {
                this.binderService.release();
                serviceController.removeListener((ServiceListener)this);
            }
        }

        public void transition(ServiceController<? extends T> serviceController, ServiceController.Transition transition) {
            if (transition.getAfter() == ServiceController.Substate.STOPPING) {
                this.binderService.release();
                serviceController.removeListener((ServiceListener)this);
            }
        }
    }

    private static class IntHolder {
        private int value = 0;

        private IntHolder() {
        }
    }
}

