/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.ManagedReferenceFieldInjectionInterceptorFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.value.Value;

public final class FieldInjectionTarget
extends InjectionTarget {
    public FieldInjectionTarget(String className, String name, String fieldType) {
        super(className, name, fieldType);
    }

    @Override
    public boolean isStatic(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        return Modifier.isStatic(this.getField(deploymentUnit).getModifiers());
    }

    @Override
    public InterceptorFactory createInjectionInterceptorFactory(Object targetContextKey, Object valueContextKey, Value<ManagedReferenceFactory> factoryValue, DeploymentUnit deploymentUnit, boolean optional) throws DeploymentUnitProcessingException {
        return new ManagedReferenceFieldInjectionInterceptorFactory(targetContextKey, valueContextKey, factoryValue, this.getField(deploymentUnit), optional);
    }

    private Field getField(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        ClassReflectionIndex classIndex;
        String name = this.getName();
        String className = this.getClassName();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        try {
            classIndex = reflectionIndex.getClassIndex(Class.forName(className, false, (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        Field field = classIndex.getField(name);
        if (field == null) {
            throw EeMessages.MESSAGES.fieldNotFound(name);
        }
        return field;
    }
}

