/*
 * JBoss, Home of Professional Open Source.
 * Copyright (c) 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.ejb3.component.messagedriven;

import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.base.BaseInvocationContext;
import org.jboss.ejb3.context.spi.InvocationContext;
import org.jboss.ejb3.context.spi.MessageDrivenContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 */
class MessageDrivenInvocationContextInterceptor implements Interceptor {
    static final MessageDrivenInvocationContextInterceptor INSTANCE = new MessageDrivenInvocationContextInterceptor();

    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        Method method = context.getMethod();
        Object[] parameters = context.getParameters();
        InvocationContext invocationContext = new CustomInvocationContext(context, method, parameters);
        context.putPrivateData(InvocationContext.class, invocationContext);
        CurrentInvocationContext.push(invocationContext);
        try {
            return context.proceed();
        }
        finally {
            CurrentInvocationContext.pop();
            context.putPrivateData(InvocationContext.class, null);
        }
    }

    protected static class CustomInvocationContext extends BaseInvocationContext {
        private InterceptorContext context;

        protected CustomInvocationContext(InterceptorContext context, Method method, Object[] parameters) {
            super(method, parameters);

            this.context = context;
        }

        @Override
        public Map<String, Object> getContextData() {
            return context.getContextData();
        }

        @Override
        public MessageDrivenContext getEJBContext() {
            return ((MessageDrivenComponentInstance) context.getPrivateData(ComponentInstance.class)).getMessageDrivenContext();
        }

        @Override
        public Object proceed() throws Exception {
            return context.proceed();
        }

        @Override
        public void setParameters(Object[] params) throws IllegalArgumentException, IllegalStateException {
            context.setParameters(params);
        }
    }
}
