/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.concurrency;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.IllegalLoopbackException;

public class EJBReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ThreadLocal<Integer> readLockCount = new ThreadLocal();
    private final ReentrantReadWriteLock delegate = new ReentrantReadWriteLock();
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();

    private void checkLoopback() {
        Integer current = this.readLockCount.get();
        if (current != null) {
            assert (current > 0) : "readLockCount is set, but to 0";
            throw new IllegalLoopbackException("EJB 3.1 PFD2 4.8.5.1.1 upgrading from read to write lock is not allowed");
        }
    }

    private void decReadLockCount() {
        Integer current = this.readLockCount.get();
        assert (current != null) : "can't decrease, readLockCount is not set";
        int next = current - 1;
        if (next == 0) {
            this.readLockCount.remove();
        } else {
            this.readLockCount.set(new Integer(next));
        }
    }

    private void incReadLockCount() {
        Integer current = this.readLockCount.get();
        int next = current == null ? 1 : current + 1;
        this.readLockCount.set(new Integer(next));
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    public class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public void lock() {
            EJBReadWriteLock.this.checkLoopback();
            EJBReadWriteLock.this.delegate.writeLock().lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            EJBReadWriteLock.this.checkLoopback();
            EJBReadWriteLock.this.delegate.writeLock().lockInterruptibly();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            EJBReadWriteLock.this.checkLoopback();
            return EJBReadWriteLock.this.delegate.writeLock().tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            EJBReadWriteLock.this.checkLoopback();
            return EJBReadWriteLock.this.delegate.writeLock().tryLock(time, unit);
        }

        @Override
        public void unlock() {
            EJBReadWriteLock.this.delegate.writeLock().unlock();
        }
    }

    public class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public void lock() {
            EJBReadWriteLock.this.delegate.readLock().lock();
            EJBReadWriteLock.this.incReadLockCount();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            EJBReadWriteLock.this.delegate.readLock().lockInterruptibly();
            EJBReadWriteLock.this.incReadLockCount();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            if (EJBReadWriteLock.this.delegate.readLock().tryLock()) {
                EJBReadWriteLock.this.incReadLockCount();
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            if (EJBReadWriteLock.this.delegate.readLock().tryLock(time, unit)) {
                EJBReadWriteLock.this.incReadLockCount();
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            EJBReadWriteLock.this.delegate.readLock().unlock();
            EJBReadWriteLock.this.decReadLockCount();
        }
    }
}

