/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.pool.strictmax;

import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBException;
import org.jboss.as.ejb3.pool.AbstractPool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.logging.Logger;

public class StrictMaxPool<T>
extends AbstractPool<T> {
    private static final Logger log = Logger.getLogger(StrictMaxPool.class);
    private final Semaphore semaphore;
    private final int maxSize;
    private final long timeout;
    private final TimeUnit timeUnit;
    private final LinkedList<T> pool = new LinkedList();
    private int inUse = 0;

    public StrictMaxPool(StatelessObjectFactory<T> factory, int maxSize, long timeout, TimeUnit timeUnit) {
        super(factory);
        this.maxSize = maxSize;
        this.semaphore = new Semaphore(maxSize, true);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void discard(T ctx) {
        if (log.isTraceEnabled()) {
            String msg = "Discard instance:" + this + "#" + ctx;
            log.trace((Object)msg);
        }
        this.semaphore.release();
        --this.inUse;
        super.doRemove(ctx);
    }

    @Override
    public int getCurrentSize() {
        return this.getCreateCount() - this.getRemoveCount();
    }

    @Override
    public int getAvailableCount() {
        return this.maxSize - this.inUse;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        throw new RuntimeException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        try {
            boolean acquired = this.semaphore.tryAcquire(this.timeout, this.timeUnit);
            if (!acquired) {
                throw new EJBException("Failed to acquire a permit within " + this.timeout + " " + (Object)((Object)this.timeUnit));
            }
        }
        catch (InterruptedException e) {
            throw new EJBException("Acquire semaphore was interrupted");
        }
        LinkedList<T> e = this.pool;
        synchronized (e) {
            if (!this.pool.isEmpty()) {
                return this.pool.removeFirst();
            }
        }
        T bean = null;
        try {
            ++this.inUse;
            bean = this.create();
        }
        finally {
            if (bean == null) {
                --this.inUse;
                this.semaphore.release();
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T obj) {
        if (log.isTraceEnabled()) {
            String msg = this.pool.size() + "/" + this.maxSize + " Free instance:" + this;
            log.trace((Object)msg);
        }
        boolean destroyIt = false;
        LinkedList<T> linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxSize) {
                this.pool.add(obj);
            } else {
                destroyIt = true;
            }
        }
        if (destroyIt) {
            this.destroy(obj);
        }
        this.semaphore.release();
        --this.inUse;
    }

    @Override
    public void remove(T ctx) {
        if (log.isTraceEnabled()) {
            String msg = "Removing instance:" + this + "#" + ctx;
            log.trace((Object)msg);
        }
        this.semaphore.release();
        --this.inUse;
        super.doRemove(ctx);
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LinkedList<T> linkedList = this.pool;
        synchronized (linkedList) {
            for (Object obj : this.pool) {
                this.destroy(obj);
            }
            this.pool.clear();
        }
    }
}

