/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.mk2.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TimeoutMethod
implements Serializable {
    private Long id;
    private String declaringClass;
    private String methodName;
    private List<String> methodParams;
    private transient String cachedToString;

    public TimeoutMethod() {
    }

    public TimeoutMethod(String declaringClass, String methodName, String[] methodParams) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        if (methodParams != null) {
            this.methodParams = new ArrayList<String>(Arrays.asList(methodParams));
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getMethodParams() {
        if (this.methodParams == null) {
            return null;
        }
        return this.methodParams.toArray(new String[0]);
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.declaringClass);
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            if (this.methodParams != null) {
                for (int i = 0; i < this.methodParams.size(); ++i) {
                    sb.append(this.methodParams.get(i));
                    if (i == this.methodParams.size() - 1) continue;
                    sb.append(",");
                }
            }
            sb.append(")");
            this.cachedToString = sb.toString();
        }
        return this.cachedToString;
    }
}

