/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.ejb.EJBException;
import javax.interceptor.AroundInvoke;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.ejb3.tx.TransactionalInvocationContext;
import org.jboss.logging.Logger;

public abstract class BMTInterceptor {
    private static final Logger log = Logger.getLogger(BMTInterceptor.class);

    protected abstract String getComponentName();

    protected abstract Object handleInvocation(TransactionalInvocationContext var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object invoke(TransactionalInvocationContext invocation) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction oldTx = tm.suspend();
        try {
            Object object = this.handleInvocation(invocation);
            return object;
        }
        finally {
            if (oldTx != null) {
                tm.resume(oldTx);
            }
        }
    }

    protected abstract TransactionManager getTransactionManager();

    protected Exception handleException(TransactionalInvocationContext invocation, Exception ex) throws Exception {
        ApplicationExceptionDetails ae = invocation.getApplicationException(ex.getClass());
        if (ae != null) {
            throw ex;
        }
        if (ex instanceof EJBException) {
            throw (EJBException)ex;
        }
        throw new EJBException(ex);
    }
}

