/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.ModelDescriptionConstants;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

/**
 * @author Stuart Douglas
 */
public class DefaultSessionBeanAccessTimeoutWriteHandler extends AbstractWriteAttributeHandler<Void> {

    private final AttributeDefinition attribute;
    private final ServiceName serviceName;

    public DefaultSessionBeanAccessTimeoutWriteHandler(final AttributeDefinition attribute, final ServiceName serviceName) {
        super(attribute);
        this.attribute = attribute;
        this.serviceName = serviceName;
    }

    @Override
    protected void validateResolvedValue(String attributeName, ModelNode value) throws OperationFailedException {
        // we're going to validate using the AttributeDefinition in applyModelToRuntime, so don't bother here
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        final ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        applyModelToRuntime(context, model);
        return false;
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        final ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        applyModelToRuntime(context, restored);
    }


    private void applyModelToRuntime(OperationContext context, final ModelNode model) throws OperationFailedException {
        long timeout = attribute.resolveModelAttribute(context, model).asLong();
        final ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController<DefaultAccessTimeoutService> controller = (ServiceController<DefaultAccessTimeoutService>) serviceRegistry.getService(serviceName);
        if (controller != null) {
            DefaultAccessTimeoutService service = controller.getValue();
            if (service != null) {
                service.setDefaultAccessTimeout(timeout);
            }
        }
    }

}
