/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.logging.Logger;

public class StatefulComponentIdInterceptor
extends AbstractEJBInterceptor {
    private static final Logger log = Logger.getLogger(StatefulComponentIdInterceptor.class);
    private final AtomicReference<SessionID> reference;

    public StatefulComponentIdInterceptor(AtomicReference<SessionID> reference) {
        this.reference = reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        try {
            context.putPrivateData((Object)SessionID.SESSION_ID_KEY, (Object)this.reference.get());
            Object object = context.proceed();
            return object;
        }
        finally {
            context.putPrivateData((Object)SessionID.SESSION_ID_KEY, null);
        }
    }

    public static class Factory
    implements InterceptorFactory {
        public static final InterceptorFactory INSTANCE = new Factory();

        private Factory() {
        }

        public Interceptor create(InterceptorFactoryContext context) {
            AtomicReference reference = (AtomicReference)context.getContextData().get(StatefulSessionComponent.SESSION_ID_REFERENCE_KEY);
            return new StatefulComponentIdInterceptor(reference);
        }
    }
}

