/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;

public class MethodPermissionsMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    private static final Logger logger = Logger.getLogger(MethodPermissionsMergingProcessor.class);

    public MethodPermissionsMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, RolesAllowed.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            description.setRolesAllowedOnAllViewsForClass((String)entry.getKey(), new HashSet<Object>(Arrays.asList((Object[])((List)entry.getValue()).get(0))));
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            EJBMethodIdentifier identifier = EJBMethodIdentifier.fromMethod((Method)entry.getKey());
            description.setRolesAllowedOnAllViewsForMethod(identifier, new HashSet<Object>(Arrays.asList((Object[])((List)entry.getValue()).get(0))));
        }
        RuntimeAnnotationInformation denyData = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, DenyAll.class);
        for (Map.Entry entry : denyData.getClassAnnotations().entrySet()) {
            description.applyDenyAllOnAllViewsForClass((String)entry.getKey());
        }
        for (Map.Entry entry : denyData.getMethodAnnotations().entrySet()) {
            EJBMethodIdentifier identifier = EJBMethodIdentifier.fromMethod((Method)entry.getKey());
            description.applyDenyAllOnAllViewsForMethod(identifier);
        }
        RuntimeAnnotationInformation permitData = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, PermitAll.class);
        for (Map.Entry entry : permitData.getClassAnnotations().entrySet()) {
            description.applyPermitAllOnAllViewsForClass((String)entry.getKey());
        }
        for (Map.Entry entry : permitData.getMethodAnnotations().entrySet()) {
            EJBMethodIdentifier identifier = EJBMethodIdentifier.fromMethod((Method)entry.getKey());
            description.applyPermitAllOnAllViewsForMethod(identifier);
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription description) throws DeploymentUnitProcessingException {
        EnterpriseBeanMetaData beanMetaData = description.getDescriptorData();
        if (beanMetaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = beanMetaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        ClassReflectionIndex classReflectionIndex = deploymentReflectionIndex.getClassIndex(componentClass);
        this.handleMethodPermissions(deploymentReflectionIndex, description, assemblyDescriptor, classReflectionIndex);
        this.handleExcludeList(deploymentReflectionIndex, description, assemblyDescriptor, classReflectionIndex);
    }

    private void handleExcludeList(DeploymentReflectionIndex deploymentReflectionIndex, EJBComponentDescription description, AssemblyDescriptorMetaData assemblyDescriptor, ClassReflectionIndex<?> classReflectionIndex) {
        ExcludeListMetaData excludeList = assemblyDescriptor.getExcludeListByEjbName(description.getEJBName());
        if (excludeList == null) {
            return;
        }
        MethodsMetaData methods = excludeList.getMethods();
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (MethodMetaData denyAllMethod : methods) {
            String methodName = denyAllMethod.getMethodName();
            MethodIntf methodIntf = this.getMethodIntf(denyAllMethod.getMethodIntf());
            if (methodName.equals("*")) {
                if (methodIntf == null) {
                    description.applyDenyAllOnAllMethodsOfAllViews();
                    continue;
                }
                description.applyDenyAllOnAllMethodsOfViewType(methodIntf);
                continue;
            }
            MethodParametersMetaData methodParams = denyAllMethod.getMethodParams();
            if (methodParams == null || methodParams.isEmpty()) {
                Collection denyAllApplicableMethods = ClassReflectionIndexUtil.findAllMethodsByName((DeploymentReflectionIndex)deploymentReflectionIndex, classReflectionIndex, (String)methodName);
                if (denyAllApplicableMethods.isEmpty()) {
                    EjbLogger.ROOT_LOGGER.noMethodFoundOnEjbExcludeList(methodName, description.getEJBName());
                    continue;
                }
                this.applyDenyAll(description, methodIntf, denyAllApplicableMethods);
                continue;
            }
            Object[] paramTypes = (String[])methodParams.toArray((Object[])new String[methodParams.size()]);
            Collection denyAllApplicableMethods = ClassReflectionIndexUtil.findMethods((DeploymentReflectionIndex)deploymentReflectionIndex, classReflectionIndex, (String)methodName, (String[])paramTypes);
            if (denyAllApplicableMethods.isEmpty()) {
                EjbLogger.ROOT_LOGGER.noMethodFoundOnEjbWithParamExcludeList(methodName, Arrays.toString(paramTypes), description.getEJBName());
                continue;
            }
            this.applyDenyAll(description, methodIntf, denyAllApplicableMethods);
        }
    }

    private void handleMethodPermissions(DeploymentReflectionIndex deploymentReflectionIndex, EJBComponentDescription description, AssemblyDescriptorMetaData assemblyDescriptor, ClassReflectionIndex<?> classReflectionIndex) {
        MethodPermissionsMetaData methodPermissions = assemblyDescriptor.getMethodPermissionsByEjbName(description.getEJBName());
        if (methodPermissions == null || methodPermissions.isEmpty()) {
            return;
        }
        for (MethodPermissionMetaData methodPermission : methodPermissions) {
            MethodsMetaData methods = methodPermission.getMethods();
            if (methods == null || methods.isEmpty() || methodPermission.isNotChecked()) continue;
            Set securityRoles = methodPermission.getRoles();
            for (MethodMetaData method : methods) {
                String methodName = method.getMethodName();
                MethodIntf methodIntf = this.getMethodIntf(method.getMethodIntf());
                if (methodName.equals("*")) {
                    if (methodIntf == null) {
                        description.setRolesAllowedForAllMethodsOfAllViews(securityRoles);
                        continue;
                    }
                    description.setRolesAllowedForAllMethodsOnViewType(methodIntf, securityRoles);
                    continue;
                }
                MethodParametersMetaData methodParams = method.getMethodParams();
                if (methodParams == null || methodParams.isEmpty()) {
                    Collection applicableMethods = ClassReflectionIndexUtil.findAllMethodsByName((DeploymentReflectionIndex)deploymentReflectionIndex, classReflectionIndex, (String)methodName);
                    if (applicableMethods.isEmpty()) {
                        EjbLogger.ROOT_LOGGER.noMethodFoundOnEjbPermission(methodName, description.getEJBName());
                        continue;
                    }
                    this.setRolesAllowed(description, methodIntf, applicableMethods, securityRoles);
                    continue;
                }
                Object[] paramTypes = (String[])methodParams.toArray((Object[])new String[methodParams.size()]);
                Collection applicableMethods = ClassReflectionIndexUtil.findMethods((DeploymentReflectionIndex)deploymentReflectionIndex, classReflectionIndex, (String)methodName, (String[])paramTypes);
                if (applicableMethods.isEmpty()) {
                    EjbLogger.ROOT_LOGGER.noMethodFoundWithParamOnEjbMethodPermission(methodName, Arrays.toString(paramTypes), description.getEJBName());
                    continue;
                }
                this.setRolesAllowed(description, methodIntf, applicableMethods, securityRoles);
            }
        }
    }

    private void setRolesAllowed(EJBComponentDescription ejbComponentDescription, MethodIntf viewType, Collection<Method> rolesAllowedApplicableMethods, Collection<String> roles) {
        for (Method denyAllApplicableMethod : rolesAllowedApplicableMethods) {
            EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethod(denyAllApplicableMethod);
            if (viewType == null) {
                ejbComponentDescription.setRolesAllowedOnAllViewsForMethod(ejbMethodIdentifier, new HashSet<String>(roles));
                continue;
            }
            ejbComponentDescription.setRolesAllowedForMethodOnViewType(viewType, ejbMethodIdentifier, new HashSet<String>(roles));
        }
    }

    private void applyDenyAll(EJBComponentDescription ejbComponentDescription, MethodIntf viewType, Collection<Method> denyAllApplicableMethods) {
        for (Method denyAllApplicableMethod : denyAllApplicableMethods) {
            EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethod(denyAllApplicableMethod);
            if (viewType == null) {
                ejbComponentDescription.applyDenyAllOnAllViewsForMethod(ejbMethodIdentifier);
                continue;
            }
            ejbComponentDescription.applyDenyAllOnViewTypeForMethod(viewType, ejbMethodIdentifier);
        }
    }

    @Override
    protected MethodIntf getMethodIntf(MethodInterfaceType viewType) {
        if (viewType == null) {
            return null;
        }
        return super.getMethodIntf(viewType);
    }
}

