/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.remote.RemoteAsyncInvocationCancelStatusService;
import org.jboss.as.ejb3.remote.protocol.versionone.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.logging.Logger;
import org.jboss.remoting3.MessageInputStream;

class InvocationCancellationMessageHandler
extends AbstractMessageHandler {
    private static final Logger logger = Logger.getLogger(InvocationCancellationMessageHandler.class);
    private final RemoteAsyncInvocationCancelStatusService remoteAsyncInvocationCancelStatus;

    InvocationCancellationMessageHandler(RemoteAsyncInvocationCancelStatusService asyncInvocationCancelStatus) {
        this.remoteAsyncInvocationCancelStatus = asyncInvocationCancelStatus;
    }

    @Override
    public void processMessage(ChannelAssociation channelAssociation, MessageInputStream messageInputStream) throws IOException {
        DataInputStream input = new DataInputStream((InputStream)messageInputStream);
        short invocationToCancel = input.readShort();
        CancellationFlag cancellationFlag = this.remoteAsyncInvocationCancelStatus.getCancelStatus(invocationToCancel);
        if (cancellationFlag == null) {
            return;
        }
        cancellationFlag.set(true);
        logger.debug((Object)("Invocation with id " + invocationToCancel + " has been marked as cancelled, as requested"));
    }
}

