/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import javax.xml.namespace.QName;
import org.jboss.as.controller.parsing.DomainXml;
import org.jboss.as.controller.parsing.HostXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.modules.Module;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ConfigurationPersisterFactory {
    private static final String HOST_XML = "host.xml";
    private static final String DOMAIN_XML = "domain.xml";

    public static ExtensibleConfigurationPersister createHostXmlConfigurationPersister(File configDir) {
        HostXml hostXml = new HostXml(Module.getBootModuleLoader());
        return new BackupXmlConfigurationPersister(ConfigurationPersisterFactory.getFile(configDir, HOST_XML), new QName(Namespace.CURRENT.getUriString(), "host"), (XMLElementReader)hostXml, (XMLElementWriter)hostXml);
    }

    public static ExtensibleConfigurationPersister createDomainXmlConfigurationPersister(File configDir) {
        return ConfigurationPersisterFactory.createDomainXmlConfigurationPersister(configDir, DOMAIN_XML);
    }

    public static ExtensibleConfigurationPersister createDomainXmlConfigurationPersister(File configDir, String name) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader());
        return new BackupXmlConfigurationPersister(ConfigurationPersisterFactory.getFile(configDir, name), new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader)domainXml, (XMLElementWriter)domainXml);
    }

    private static File getFile(File configDir, String file) {
        if (configDir == null) {
            throw new IllegalArgumentException("Domain configuration directory is null");
        }
        File configFile = new File(configDir, file);
        if (configFile.exists()) {
            if (configFile.isDirectory()) {
                throw new IllegalArgumentException(configFile.getAbsolutePath() + " is a directory");
            }
        } else if (configFile.isDirectory() || !configDir.canWrite()) {
            throw new IllegalArgumentException(configFile.getAbsolutePath() + " is not a writable");
        }
        return configFile;
    }
}

