/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.LocalHostModel;
import org.jboss.as.host.controller.HostControllerImpl;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class HostControllerService
implements Service<LocalHostModel> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    private final InjectedValue<ServerInventory> serverInventory = new InjectedValue();
    private final ModelNode hostModel;
    private final ExtensibleConfigurationPersister configPersister;
    private final ModelNodeRegistration registry;
    private final String name;
    private LocalHostModel proxyController;

    HostControllerService(String name, ModelNode hostModel, ExtensibleConfigurationPersister configPersister, ModelNodeRegistration registry) {
        this.name = name;
        this.hostModel = hostModel;
        this.configPersister = configPersister;
        this.registry = registry;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServerInventory serverInventory = (ServerInventory)this.serverInventory.getValue();
        final HostControllerImpl controller = new HostControllerImpl(this.name, this.hostModel, this.configPersister, this.registry, serverInventory);
        serverInventory.setHostController(controller);
        controller.registerInternalOperations();
        this.proxyController = new LocalHostModel(){

            public void startServers(DomainController domainController) {
                controller.startServers(domainController);
            }

            public void stopServers() {
                controller.stopServers();
            }

            public String getName() {
                return HostControllerService.this.name;
            }

            public ModelNode getHostModel() {
                return HostControllerService.this.hostModel;
            }

            public ModelNodeRegistration getRegistry() {
                return HostControllerService.this.registry;
            }

            public ExtensibleConfigurationPersister getConfigurationPersister() {
                return HostControllerService.this.configPersister;
            }
        };
    }

    public synchronized void stop(StopContext context) {
        this.proxyController = null;
    }

    public synchronized LocalHostModel getValue() throws IllegalStateException, IllegalArgumentException {
        LocalHostModel controller = this.proxyController;
        if (controller == null) {
            throw new IllegalArgumentException();
        }
        return controller;
    }

    InjectedValue<ServerInventory> getServerInventory() {
        return this.serverInventory;
    }
}

