/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostServerDescription {
    private static final String RESOURCE_NAME = HostServerDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getDescription(Locale locale) {
        ResourceBundle bundle = HostServerDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("server"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("server.name"));
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "group", "description"}).set(bundle.getString("server.group"));
        root.get(new String[]{"attributes", "group", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "group", "required"}).set(true);
        root.get(new String[]{"attributes", "group", "min-length"}).set(1);
        root.get(new String[]{"attributes", "auto-start", "description"}).set(bundle.getString("server.start"));
        root.get(new String[]{"attributes", "auto-start", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"attributes", "auto-start", "required"}).set(true);
        root.get(new String[]{"attributes", "priority", "description"}).set(bundle.getString("server.priority"));
        root.get(new String[]{"attributes", "priority", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "priority", "required"}).set(false);
        root.get(new String[]{"attributes", "priority", "min-value"}).set(0);
        root.get(new String[]{"attributes", "cpu-affinity", "description"}).set(bundle.getString("server.cpu-affinity"));
        root.get(new String[]{"attributes", "cpu-affinity", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "cpu-affinity", "required"}).set(false);
        root.get(new String[]{"attributes", "cpu-affinity", "min-length"}).set(1);
        root.get(new String[]{"attributes", "socket-binding-group", "description"}).set(bundle.getString("server.socket-binding-group"));
        root.get(new String[]{"attributes", "socket-binding-group", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "socket-binding-group", "required"}).set(true);
        root.get(new String[]{"attributes", "socket-binding-port-offset", "description"}).set(bundle.getString("server.socket-binding-port-offset"));
        root.get(new String[]{"attributes", "socket-binding-port-offset", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "socket-binding-port-offset", "required"}).set(false);
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "path", "description"}).set(bundle.getString("server.path"));
        root.get(new String[]{"children", "path", "min-occurs"}).set(0);
        root.get(new String[]{"children", "path", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "path", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "interface", "description"}).set(bundle.getString("server.interface"));
        root.get(new String[]{"children", "interface", "min-occurs"}).set(0);
        root.get(new String[]{"children", "interface", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "interface", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "system-property", "description"}).set(bundle.getString("server.system-property"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "system-property", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "jvm", "description"}).set(bundle.getString("server.jvm"));
        root.get(new String[]{"children", "jvm", "min-occurs"}).set(0);
        root.get(new String[]{"children", "jvm", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "jvm", "model-description"}).setEmptyObject();
        return root;
    }

    private static void populateServer(ModelNode root, ResourceBundle bundle, boolean specified) {
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get("operations").setEmptyObject();
    }

    public static ModelNode getServerAddOperation(Locale locale) {
        ResourceBundle bundle = HostServerDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getServerRemoveOperation(Locale locale) {
        ResourceBundle bundle = HostServerDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

