/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.host.controller.HostController;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.dmr.ModelNode;

public class ServerRestartHandler
implements ModelQueryOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "restart";
    private final HostController hostController;

    public ServerRestartHandler(HostController hostController) {
        this.hostController = hostController;
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        String serverName = element.getValue();
        ServerStatus status = this.hostController.restartServer(serverName);
        resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, new ModelNode().set(status.toString()));
        resultHandler.handleResultComplete();
        return new BasicOperationResult();
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getRestartServerOperation(locale);
    }
}

