/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.as.host.controller.HostControllerBootstrap;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.SecurityActions;
import org.jboss.as.host.controller.SystemExiter;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.logging.MDC;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public final class Main {
    public static void main(String[] args) throws IOException {
        MDC.put((String)"process", (Object)"host controller");
        InputStream in = System.in;
        PrintStream out = System.out;
        PrintStream err = System.err;
        byte[] authKey = new byte[16];
        try {
            StreamUtils.readFully((InputStream)System.in, (byte[])authKey);
        }
        catch (IOException e) {
            System.err.printf("Failed to read authentication key: %s", e);
            System.exit(1);
            return;
        }
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        Main.create(args, in, out, err, authKey);
        while (in.read() != -1) {
        }
        System.exit(0);
    }

    private Main() {
    }

    private static HostControllerBootstrap create(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr, byte[] authCode) {
        Main main = new Main();
        return main.boot(args, stdin, stdout, stderr, authCode);
    }

    private HostControllerBootstrap boot(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr, byte[] authCode) {
        HostControllerBootstrap hc = null;
        try {
            HostControllerEnvironment config = Main.determineEnvironment(args, stdin, stdout, stderr);
            if (config == null) {
                this.abort(null);
                return null;
            }
            hc = new HostControllerBootstrap(config, authCode);
            hc.start();
        }
        catch (Throwable t) {
            t.printStackTrace(stderr);
            this.abort(t);
            return null;
        }
        return hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(Throwable t) {
        int exitCode = 1;
        try {
            if (t != null) {
                t.printStackTrace();
            } else {
                exitCode = 99;
            }
        }
        finally {
            SystemExiter.exit(exitCode);
        }
    }

    public static HostControllerEnvironment determineEnvironment(String[] args, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        Integer pmPort = null;
        InetAddress pmAddress = null;
        Integer smPort = 0;
        InetAddress smAddress = null;
        try {
            smAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String procName = "Host Controller";
        String defaultJVM = null;
        boolean isRestart = false;
        boolean backupDomainFiles = false;
        boolean cachedDc = false;
        String domainConfig = null;
        String hostConfig = null;
        HashMap<String, String> hostSystemProperties = new HashMap<String, String>();
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String value;
                InetAddress addr;
                Integer port;
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    System.out.println("JBoss Application Server " + org.jboss.as.process.Main.getVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    org.jboss.as.process.Main.usage();
                    return null;
                }
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(arg, args[++i])) continue;
                    return null;
                }
                if (arg.startsWith("--properties")) {
                    String urlSpec = Main.parseValue(arg, "--properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-P")) {
                    String urlSpec = Main.parseValue(arg, "-P");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-properties")) {
                    String urlSpec = Main.parseValue(arg, "-properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if ("--pc-port".equals(arg)) {
                    String port2 = args[++i];
                    try {
                        pmPort = Integer.valueOf(port2);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.printf("Value for %s is not an Integer -- %s\n", "--pc-port", port2);
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                }
                if (arg.startsWith("--pc-port")) {
                    String val = Main.parseValue(arg, "--pc-port");
                    if (val == null) {
                        return null;
                    }
                    port = Main.parsePort(val, "--pc-port");
                    if (port == null) {
                        return null;
                    }
                    pmPort = port;
                    continue;
                }
                if ("--pc-address".equals(arg)) {
                    String addr2 = args[++i];
                    try {
                        pmAddress = InetAddress.getByName(addr2);
                        continue;
                    }
                    catch (UnknownHostException e) {
                        System.err.printf("Value for %s is not a known host -- %s\n", "--pc-address", addr2);
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                }
                if (arg.startsWith("--pc-address")) {
                    String val = Main.parseValue(arg, "--pc-address");
                    if (val == null) {
                        return null;
                    }
                    addr = Main.parseAddress(val, arg);
                    if (addr == null) {
                        return null;
                    }
                    pmAddress = addr;
                    continue;
                }
                if ("--interprocess-hc-port".equals(arg) || "-interprocess-hc-port".equals(arg)) {
                    Integer port3;
                    if ((port3 = Main.parsePort(args[++i], arg)) == null) {
                        return null;
                    }
                    smPort = port3;
                    continue;
                }
                if (arg.startsWith("--interprocess-hc-port")) {
                    String val = Main.parseValue(arg, "--interprocess-hc-port");
                    if (val == null) {
                        return null;
                    }
                    port = Main.parsePort(val, "--interprocess-hc-port");
                    if (port == null) {
                        return null;
                    }
                    smPort = port;
                    continue;
                }
                if (arg.startsWith("-interprocess-hc-port")) {
                    String val = Main.parseValue(arg, "--interprocess-hc-port");
                    if (val == null) {
                        return null;
                    }
                    port = Main.parsePort(val, "--interprocess-hc-port");
                    if (port == null) {
                        return null;
                    }
                    smPort = port;
                    continue;
                }
                if ("--interprocess-hc-address".equals(arg) || "-interprocess-hc-address".equals(arg)) {
                    InetAddress addr3;
                    if ((addr3 = Main.parseAddress(args[++i], arg)) == null) {
                        return null;
                    }
                    smAddress = addr3;
                    continue;
                }
                if (arg.startsWith("--interprocess-hc-address")) {
                    String val = Main.parseValue(arg, "--interprocess-hc-address");
                    if (val == null) {
                        return null;
                    }
                    addr = Main.parseAddress(val, arg);
                    if (addr == null) {
                        return null;
                    }
                    smAddress = addr;
                    continue;
                }
                if (arg.startsWith("-interprocess-hc-address")) {
                    String val = Main.parseValue(arg, "-interprocess-hc-address");
                    if (val == null) {
                        return null;
                    }
                    addr = Main.parseAddress(val, arg);
                    if (addr == null) {
                        return null;
                    }
                    smAddress = addr;
                    continue;
                }
                if ("--restarted-host-controller".equals(arg)) {
                    isRestart = true;
                    continue;
                }
                if ("--backup".equals(arg) || "-backup".equals(arg)) {
                    backupDomainFiles = true;
                    continue;
                }
                if ("--cached-dc".equals(arg) || "-cached-dc".equals(arg)) {
                    cachedDc = true;
                    continue;
                }
                if ("--default-jvm".equals(arg) || "-default-jvm".equals(arg)) {
                    defaultJVM = args[++i];
                    continue;
                }
                if ("--domain-config".equals(arg) || "-domain-config".equals(arg)) {
                    domainConfig = args[++i];
                    continue;
                }
                if (arg.startsWith("--domain-config")) {
                    String val = Main.parseValue(arg, "--domain-config");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if (arg.startsWith("-domain-config")) {
                    String val = Main.parseValue(arg, "-domain-config");
                    if (val == null) {
                        return null;
                    }
                    domainConfig = val;
                    continue;
                }
                if ("--host-config".equals(arg) || "-host-config".equals(arg)) {
                    hostConfig = args[++i];
                    continue;
                }
                if (arg.startsWith("--host-config")) {
                    String val = Main.parseValue(arg, "--host-config");
                    if (val == null) {
                        return null;
                    }
                    hostConfig = val;
                    continue;
                }
                if (arg.startsWith("-host-config")) {
                    String val = Main.parseValue(arg, "-host-config");
                    if (val == null) {
                        return null;
                    }
                    hostConfig = val;
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    SecurityActions.setSystemProperty(name, value);
                    hostSystemProperties.put(name, value);
                    continue;
                }
                if (arg.startsWith("-b")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        System.err.printf("Argument expected for option %s\n", arg);
                        org.jboss.as.process.Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    String propertyName = null;
                    propertyName = idx < 0 ? (arg.length() == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2)) : (idx == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2, idx));
                    hostSystemProperties.put(propertyName, value);
                    SecurityActions.setSystemProperty(propertyName, value);
                    continue;
                }
                System.err.printf("Invalid option '%s'\n", arg);
                org.jboss.as.process.Main.usage();
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                org.jboss.as.process.Main.usage();
                return null;
            }
        }
        return new HostControllerEnvironment(hostSystemProperties, isRestart, stdin, stdout, stderr, pmAddress, pmPort, smAddress, smPort, defaultJVM, domainConfig, hostConfig, backupDomainFiles, cachedDc);
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            org.jboss.as.process.Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static boolean processProperties(String arg, String urlSpec) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            Properties props = SecurityActions.getSystemProperties();
            props.load(url.openConnection().getInputStream());
            return true;
        }
        catch (MalformedURLException e) {
            System.err.printf("Malformed URL provided for option %s\n", arg);
            org.jboss.as.process.Main.usage();
            return false;
        }
        catch (IOException e) {
            System.err.printf("Unable to load properties from URL %s\n", url);
            org.jboss.as.process.Main.usage();
            return false;
        }
    }

    private static Integer parsePort(String value, String key) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            System.err.printf("Value for %s is not an Integer -- %s\n", key, value);
            org.jboss.as.process.Main.usage();
            return null;
        }
    }

    private static InetAddress parseAddress(String value, String key) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            System.err.printf("Value for %s is not a known host -- %s\n", key, value);
            org.jboss.as.process.Main.usage();
            return null;
        }
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }
}

