/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.security.AccessController;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;

public class HttpManagementAttributeHandlers {
    private HttpManagementAttributeHandlers() {
    }

    private static void installHttpManagementServices(ServiceTarget serviceTarget, LocalHostControllerInfo hostControllerInfo, HostControllerEnvironment environment, ServiceVerificationHandler verificationHandler) {
        String interfaceName = hostControllerInfo.getHttpManagementInterface();
        int port = hostControllerInfo.getHttpManagementPort();
        int securePort = hostControllerInfo.getHttpManagementSecurePort();
        String securityRealm = hostControllerInfo.getHttpManagementSecurityRealm();
        StringBuilder sb = new StringBuilder();
        sb.append("creating http management service using network interface (").append(interfaceName).append(")");
        if (port > -1) {
            sb.append(" port (").append(port).append(")");
        }
        if (securePort > -1) {
            sb.append(" securePort (").append(securePort).append(")");
        }
        Logger.getLogger((String)"org.jboss.as").info((Object)sb.toString());
        JBossThreadFactory httpMgmtThreads = new JBossThreadFactory(new ThreadGroup("HttpManagementService-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        HttpManagementService service = new HttpManagementService();
        ServiceBuilder builder = serviceTarget.addService(HttpManagementService.SERVICE_NAME, (Service)service).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceBinding.class, service.getInterfaceInjector()).addDependency(DomainModelControllerService.SERVICE_NAME, ModelController.class, service.getModelControllerInjector()).addInjection((Injector)service.getTempDirInjector(), (Object)environment.getDomainTempDir().getAbsolutePath()).addInjection(service.getPortInjector(), (Object)port).addInjection(service.getSecurePortInjector(), (Object)securePort).addInjection(service.getExecutorServiceInjector(), (Object)Executors.newCachedThreadPool((ThreadFactory)httpMgmtThreads)).addListener((ServiceListener)verificationHandler);
        if (securityRealm != null) {
            builder.addDependency(SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}), SecurityRealmService.class, (Injector)service.getSecurityRealmInjector());
        } else {
            Logger.getLogger((String)"org.jboss.as").warn((Object)"No security realm defined for http management service, all access will be unrestricted.");
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public static class HttpManagementAttributeHandler
    extends WriteAttributeHandlers.WriteAttributeOperationHandler {
        private final LocalHostControllerInfoImpl hostControllerInfo;
        private final HostControllerEnvironment environment;

        public HttpManagementAttributeHandler(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
            this.hostControllerInfo = hostControllerInfo;
            this.environment = environment;
        }

        protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode subModel = resource.getModel();
            if (!newValue.equals(currentValue)) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        String interfaceName = subModel.require("interface").asString();
                        int port = subModel.require("port").asInt();
                        String realmName = subModel.hasDefined("security-realm") ? subModel.require("security-realm").asString() : null;
                        HttpManagementAttributeHandler.this.hostControllerInfo.setHttpManagementInterface(interfaceName);
                        HttpManagementAttributeHandler.this.hostControllerInfo.setHttpManagementPort(port);
                        HttpManagementAttributeHandler.this.hostControllerInfo.setHttpManagementSecurityRealm(realmName);
                        context.removeService(HttpManagementService.SERVICE_NAME);
                        ServiceVerificationHandler handler = new ServiceVerificationHandler();
                        HttpManagementAttributeHandlers.installHttpManagementServices(context.getServiceTarget(), HttpManagementAttributeHandler.this.hostControllerInfo, HttpManagementAttributeHandler.this.environment, handler);
                        context.addStep((OperationStepHandler)handler, OperationContext.Stage.VERIFY);
                        context.completeStep();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.completeStep();
        }
    }
}

