/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainContentRepository;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainModelUtil;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.descriptions.HostRootDescription;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;

public class LocalDomainControllerAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "write-local-domain-controller";
    private final ManagementResourceRegistration rootRegistration;
    private final HostControllerEnvironment environment;
    private final HostControllerConfigurationPersister overallConfigPersister;
    private final FileRepository fileRepository;
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final DomainController domainController;
    private final UnregisteredHostChannelRegistry registry;

    public static LocalDomainControllerAddHandler getInstance(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment, HostControllerConfigurationPersister overallConfigPersister, FileRepository fileRepository, DomainController domainController, UnregisteredHostChannelRegistry registry) {
        return new LocalDomainControllerAddHandler(rootRegistration, hostControllerInfo, environment, overallConfigPersister, fileRepository, domainController, registry);
    }

    LocalDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment, HostControllerConfigurationPersister overallConfigPersister, FileRepository fileRepository, DomainController domainController, UnregisteredHostChannelRegistry registry) {
        this.environment = environment;
        this.rootRegistration = rootRegistration;
        this.overallConfigPersister = overallConfigPersister;
        this.fileRepository = fileRepository;
        this.hostControllerInfo = hostControllerInfo;
        this.domainController = domainController;
        this.registry = registry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        dc.get("local").setEmptyObject();
        if (dc.has("remote")) {
            dc.remove("remote");
        }
        this.hostControllerInfo.setMasterDomainController(true);
        this.overallConfigPersister.initializeDomainConfigurationPersister(false);
        DomainContentRepository contentRepo = new DomainContentRepository(this.environment.getDomainDeploymentDir());
        this.hostControllerInfo.setContentRepository((ContentRepository)contentRepo);
        DomainModelUtil.initializeMasterDomainRegistry((ManagementResourceRegistration)this.rootRegistration, (ExtensibleConfigurationPersister)this.overallConfigPersister.getDomainPersister(), (ContentRepository)contentRepo, (FileRepository)this.fileRepository, (DomainController)this.domainController, (UnregisteredHostChannelRegistry)this.registry);
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostRootDescription.getLocalDomainControllerAdd(locale);
    }
}

