/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.AbstractServerUpdateTask;
import org.jboss.as.domain.controller.plan.NewServerOperationExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class NewRunningServerUpdateTask
extends AbstractServerUpdateTask {
    private final NewServerOperationExecutor serverOperationExecutor;
    private final ModelNode serverUpdate;

    NewRunningServerUpdateTask(NewServerOperationExecutor serverOperationExecutor, ServerIdentity serverId, ModelNode serverUpdate, ServerUpdatePolicy updatePolicy, AbstractServerUpdateTask.ServerUpdateResultHandler resultHandler) {
        super(serverId, updatePolicy, resultHandler);
        this.serverOperationExecutor = serverOperationExecutor;
        this.serverUpdate = serverUpdate;
    }

    @Override
    protected void processUpdates() {
        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Applying operation to  %s", this.serverId);
        ModelNode op = this.getServerOp();
        ModelNode rsp = this.serverOperationExecutor.executeServerOperation(this.serverId, op);
        if (rsp != null) {
            this.updatePolicy.recordServerResult(this.serverId, rsp);
            this.resultHandler.handleServerUpdateResult(this.serverId, rsp);
        }
    }

    private ModelNode getServerOp() {
        ModelNode op = this.serverUpdate.clone();
        ModelNode address = new ModelNode();
        address.add("host", this.serverId.getHostName());
        address.add("server", this.serverId.getServerName());
        if (this.serverUpdate.hasDefined("address")) {
            for (Property prop : this.serverUpdate.get("address").asPropertyList()) {
                address.add(prop.getName(), prop.getValue().asString());
            }
        }
        op.get("address").set(address);
        return op;
    }
}

