/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.remote.RemoteProxyController;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ModelCombiner;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.server.ServerState;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class ServerInventoryImpl
implements ServerInventory {
    private final Map<String, ManagedServer> servers = Collections.synchronizedMap(new HashMap());
    private final HostControllerEnvironment environment;
    private final ProcessControllerClient processControllerClient;
    private final InetSocketAddress managementAddress;
    private final DomainController domainController;
    private final Object shutdownCondition = new Object();
    private volatile CountDownLatch processInventoryLatch;
    private volatile Map<String, ProcessInfo> processInfos;
    private volatile boolean stopped;

    ServerInventoryImpl(DomainController domainController, HostControllerEnvironment environment, InetSocketAddress managementAddress, ProcessControllerClient processControllerClient) {
        this.domainController = domainController;
        this.environment = environment;
        this.managementAddress = managementAddress;
        this.processControllerClient = processControllerClient;
    }

    @Override
    public String getServerProcessName(String serverName) {
        return ManagedServer.getServerProcessName(serverName);
    }

    @Override
    public String getProcessServerName(String processName) {
        return ManagedServer.getServerName(processName);
    }

    @Override
    public synchronized Map<String, ProcessInfo> determineRunningProcesses() {
        this.processInventoryLatch = new CountDownLatch(1);
        try {
            this.processControllerClient.requestProcessInventory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (!this.processInventoryLatch.await(30L, TimeUnit.SECONDS)) {
                throw HostControllerMessages.MESSAGES.couldNotGetServerInventory(30L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.processInfos;
    }

    @Override
    public Map<String, ProcessInfo> determineRunningProcesses(boolean serversOnly) {
        Map<String, ProcessInfo> processInfos = this.determineRunningProcesses();
        if (!serversOnly) {
            return processInfos;
        }
        HashMap<String, ProcessInfo> processes = new HashMap<String, ProcessInfo>();
        for (Map.Entry<String, ProcessInfo> procEntry : processInfos.entrySet()) {
            if (!ManagedServer.isServerProcess(procEntry.getKey())) continue;
            processes.put(procEntry.getKey(), procEntry.getValue());
        }
        return processes;
    }

    @Override
    public void processInventory(Map<String, ProcessInfo> processInfos) {
        this.processInfos = processInfos;
        if (this.processInventoryLatch != null) {
            this.processInventoryLatch.countDown();
        }
    }

    @Override
    public ServerStatus determineServerStatus(String serverName) {
        ServerStatus status;
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer client = this.servers.get(processName);
        if (client == null) {
            status = ServerStatus.STOPPED;
        } else {
            switch (client.getState()) {
                case AVAILABLE: 
                case BOOTING: 
                case STARTING: {
                    status = ServerStatus.STARTING;
                    break;
                }
                case FAILED: 
                case MAX_FAILED: {
                    status = ServerStatus.FAILED;
                    break;
                }
                case STARTED: {
                    status = ServerStatus.STARTED;
                    break;
                }
                case STOPPING: {
                    status = ServerStatus.STOPPING;
                    break;
                }
                case STOPPED: {
                    status = ServerStatus.STOPPED;
                    break;
                }
                default: {
                    throw HostControllerMessages.MESSAGES.unexpectedState(client.getState());
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerStatus startServer(String serverName, ModelNode domainModel) {
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer existing = this.servers.get(processName);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(processName, existing.getState());
            return this.determineServerStatus(serverName);
        }
        HostControllerLogger.ROOT_LOGGER.startingServer(serverName);
        ManagedServer server = this.createManagedServer(serverName, domainModel);
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.servers.put(processName, server);
            this.shutdownCondition.notifyAll();
        }
        try {
            server.createServerProcess();
        }
        catch (IOException e) {
            HostControllerLogger.ROOT_LOGGER.failedToCreateServerProcess(e, serverName);
        }
        try {
            server.startServerProcess();
        }
        catch (IOException e) {
            HostControllerLogger.ROOT_LOGGER.failedToStartServer(e, serverName);
        }
        return this.determineServerStatus(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnectServer(String serverName, ModelNode domainModel, boolean running) {
        String processName = ManagedServer.getServerProcessName(serverName);
        ManagedServer existing = this.servers.get(processName);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(processName, existing.getState());
        }
        HostControllerLogger.ROOT_LOGGER.reconnectingServer(serverName);
        ManagedServer server = this.createManagedServer(serverName, domainModel);
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.servers.put(processName, server);
            this.shutdownCondition.notifyAll();
        }
        if (running) {
            try {
                server.reconnectServerProcess();
            }
            catch (IOException e) {
                HostControllerLogger.ROOT_LOGGER.failedToSendReconnect(e, serverName);
            }
        }
    }

    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
        ServerStatus status;
        this.stopServer(serverName, gracefulTimeout);
        for (int i = 0; i < 50 && (status = this.determineServerStatus(serverName)) == ServerStatus.STOPPING; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return this.startServer(serverName, domainModel);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout) {
        HostControllerLogger.ROOT_LOGGER.stoppingServer(serverName);
        String processName = ManagedServer.getServerProcessName(serverName);
        try {
            ManagedServer server = this.servers.get(processName);
            if (server != null) {
                server.setState(ServerState.STOPPING);
                if (gracefulTimeout > -1) {
                    HostControllerLogger.ROOT_LOGGER.gracefulShutdownNotSupported(serverName);
                    server.stopServerProcess();
                    server.removeServerProcess();
                } else {
                    server.stopServerProcess();
                    server.removeServerProcess();
                }
            }
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.failedToStopServer(e, serverName);
        }
        return this.determineServerStatus(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverRegistered(String serverProcessName, Channel channel, ServerInventory.ProxyCreatedCallback callback) {
        try {
            final ManagedServer server = this.servers.get(serverProcessName);
            if (server == null) {
                HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverProcessName);
                return;
            }
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    ServerInventoryImpl.this.domainController.unregisterRunningServer(server.getServerName());
                }
            });
            if (!this.environment.isRestart()) {
                this.checkState(server, ServerState.STARTING);
            }
            Object object = this.shutdownCondition;
            synchronized (object) {
                server.setState(ServerState.STARTED);
                this.shutdownCondition.notifyAll();
            }
            PathElement element = PathElement.pathElement((String)"server", (String)server.getServerName());
            RemoteProxyController serverController = RemoteProxyController.create((ExecutorService)Executors.newCachedThreadPool(), (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)this.domainController.getLocalHostInfo().getLocalHostName()), element}), (ProxyOperationAddressTranslator)ProxyOperationAddressTranslator.SERVER, (Channel)channel);
            if (callback != null && serverController instanceof ManagementMessageHandler) {
                callback.proxyOperationHandlerCreated((ManagementMessageHandler)serverController);
            }
            this.domainController.registerRunningServer((ProxyController)serverController);
            server.resetRespawnCount();
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.failedToStartServer(e, serverProcessName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStartFailed(String serverProcessName) {
        ManagedServer server = this.servers.get(serverProcessName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverProcessName);
            return;
        }
        this.checkState(server, ServerState.STARTING);
        Object object = this.shutdownCondition;
        synchronized (object) {
            server.setState(ServerState.FAILED);
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStopped(String serverProcessName) {
        ManagedServer server = this.servers.get(serverProcessName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverProcessName);
            return;
        }
        this.domainController.unregisterRunningServer(server.getServerName());
        if (server.getState() != ServerState.STOPPING && !this.stopped) {
            try {
                if (server.incrementAndGetRespawnCount() < 10) {
                    server.startServerProcess();
                    return;
                }
                server.setState(ServerState.MAX_FAILED);
            }
            catch (IOException e) {
                HostControllerLogger.ROOT_LOGGER.failedToStopServer(e, serverProcessName);
            }
        }
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.servers.remove(serverProcessName);
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public void stopServers(int gracefulTimeout) {
        this.stopServers(gracefulTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopServers(int gracefulTimeout, boolean blockUntilStopped) {
        this.stopped = true;
        Map<String, ProcessInfo> processInfoMap = this.determineRunningProcesses();
        for (String serverProcessName : processInfoMap.keySet()) {
            if (!ManagedServer.isServerProcess(serverProcessName)) continue;
            String serverName = ManagedServer.getServerName(serverProcessName);
            this.stopServer(serverName, gracefulTimeout);
        }
        if (blockUntilStopped) {
            Object object = this.shutdownCondition;
            synchronized (object) {
                while (true) {
                    int count = 0;
                    try {
                        processInfoMap = this.determineRunningProcesses();
                    }
                    catch (RuntimeException e) {
                        return;
                    }
                    block12: for (ManagedServer server : this.servers.values()) {
                        ProcessInfo info = processInfoMap.get(server.getServerProcessName());
                        switch (server.getState()) {
                            case FAILED: 
                            case MAX_FAILED: 
                            case STOPPED: {
                                continue block12;
                            }
                        }
                        if (info == null) continue;
                        ++count;
                    }
                    if (count == 0) break;
                    try {
                        this.shutdownCondition.wait(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }
    }

    private void checkState(ManagedServer server, ServerState expected) {
        ServerState state = server.getState();
        if (state != expected) {
            HostControllerLogger.ROOT_LOGGER.unexpectedServerState(server.getServerProcessName(), expected, state);
        }
    }

    private ManagedServer createManagedServer(String serverName, ModelNode domainModel) {
        String hostControllerName = this.domainController.getLocalHostInfo().getLocalHostName();
        ModelNode hostModel = domainModel.require("host").require(hostControllerName);
        ModelCombiner combiner = new ModelCombiner(serverName, domainModel, hostModel, this.domainController, this.environment);
        return new ManagedServer(hostControllerName, serverName, this.processControllerClient, this.managementAddress, combiner);
    }

    @Override
    public CallbackHandler getServerCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
                String userName = null;
                String realm = null;
                ManagedServer server = null;
                for (Callback current : callbacks) {
                    if (current instanceof AuthorizeCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)current;
                        userName = nameCallback.getDefaultName();
                        server = (ManagedServer)ServerInventoryImpl.this.servers.get(ManagedServer.getServerProcessName(userName));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof DigestHashCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        realm = ((RealmCallback)current).getDefaultText();
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
                if (server == null) {
                    return;
                }
                String password = new String(server.getAuthKey());
                for (Callback current : toRespondTo) {
                    if (current instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        ((PasswordCallback)current).setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        VerifyPasswordCallback vpc = (VerifyPasswordCallback)current;
                        vpc.setVerified(password.equals(vpc.getPassword()));
                        continue;
                    }
                    if (!(current instanceof DigestHashCallback)) continue;
                    DigestHashCallback dhc = (DigestHashCallback)current;
                    try {
                        UsernamePasswordHashUtil uph = new UsernamePasswordHashUtil();
                        if (userName == null || realm == null) {
                            throw HostControllerMessages.MESSAGES.insufficientInformationToGenerateHash();
                        }
                        dhc.setHash(uph.generateHashedURP(userName, realm, password.toCharArray()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw HostControllerMessages.MESSAGES.unableToGenerateHash(e);
                    }
                }
            }
        };
    }
}

