/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandler;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;

public class MasterDomainControllerOperationHandlerImpl
extends ManagementChannelReceiver {
    private final LocalOperationHandler clientHandler;
    private final ModelController controller;
    private final DomainController domainController;
    private final UnregisteredHostChannelRegistry registry;
    private volatile ManagementMessageHandler proxyHandler;

    public MasterDomainControllerOperationHandlerImpl(ExecutorService executorService, ModelController controller, UnregisteredHostChannelRegistry registry, DomainController domainController) {
        this.domainController = domainController;
        this.controller = controller;
        this.registry = registry;
        this.clientHandler = new LocalOperationHandler(controller, executorService);
    }

    public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) throws IOException {
        byte type = header.getType();
        if (type == 2) {
            ManagementRequestHeader request = (ManagementRequestHeader)header;
            byte id = request.getOperationId();
            AbstractHostRequestHandler handler = this.clientHandler.getRequestHandler(id);
            if (handler != null) {
                this.clientHandler.handleMessage(channel, input, header);
            }
            switch (id) {
                case 81: {
                    handler = new RegisterOperation();
                    break;
                }
                case 83: {
                    handler = new UnregisterOperation();
                    break;
                }
                case 85: {
                    handler = new GetFileOperation();
                }
            }
            if (handler != null) {
                this.clientHandler.runLocalRequestHandler(channel, input, request, handler);
            } else if (this.proxyHandler != null) {
                this.proxyHandler.handleMessage(channel, input, header);
            }
        }
    }

    static class LocalOperationHandler
    extends ModelControllerClientOperationHandler {
        LocalOperationHandler(ModelController controller, ExecutorService executorService) {
            super(controller, executorService);
        }

        protected ManagementRequestHandler<ModelNode, Void> getRequestHandler(byte operationType) {
            return super.getRequestHandler(operationType);
        }

        protected ManagementRequestHandler<ModelNode, Void> getFallbackHandler() {
            return null;
        }

        void runLocalRequestHandler(Channel channel, DataInput input, ManagementRequestHeader header, ManagementRequestHandler<ModelNode, Void> handler) {
            ActiveOperation support = super.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
            super.handleMessage(channel, input, (ManagementProtocolHeader)header, support, handler);
        }
    }

    static abstract class AbstractHostRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        AbstractHostRequestHandler() {
        }

        abstract void handleRequest(String var1, DataInput var2, ManagementRequestContext<Void> var3) throws IOException;

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            String hostId = input.readUTF();
            this.handleRequest(hostId, input, context);
            resultHandler.done(null);
        }

        protected FlushableDataOutput writeGenericResponseHeader(ManagementRequestContext<Void> context) throws IOException {
            ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
            return context.writeMessage((ManagementProtocolHeader)header);
        }
    }

    private class GetFileOperation
    extends AbstractHostRequestHandler {
        private GetFileOperation() {
        }

        @Override
        void handleRequest(String hostId, DataInput input, ManagementRequestContext<Void> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)36);
            final byte rootId = input.readByte();
            ProtocolUtils.expectHeader((DataInput)input, (int)37);
            final String filePath = input.readUTF();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    File localPath = GetFileOperation.this.processRequest(rootId, filePath);
                    FlushableDataOutput output = GetFileOperation.this.writeGenericResponseHeader(context);
                    try {
                        GetFileOperation.this.writeResponse(localPath, output);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
        }

        protected File processRequest(byte rootId, String filePath) throws RequestProcessingException {
            FileRepository localFileRepository = MasterDomainControllerOperationHandlerImpl.this.domainController.getLocalFileRepository();
            switch (rootId) {
                case 38: {
                    return localFileRepository.getFile(filePath);
                }
                case 39: {
                    return localFileRepository.getConfigurationFile(filePath);
                }
                case 40: {
                    byte[] hash = HashUtil.hexStringToByteArray((String)filePath);
                    return localFileRepository.getDeploymentRoot(hash);
                }
            }
            throw HostControllerMessages.MESSAGES.invalidRootId(rootId);
        }

        protected void writeResponse(File localPath, FlushableDataOutput output) throws IOException {
            output.writeByte(41);
            if (localPath == null || !localPath.exists()) {
                output.writeInt(-1);
            } else if (localPath.isFile()) {
                output.writeInt(1);
                this.writeFile(localPath, localPath, output);
            } else {
                List<File> childFiles = this.getChildFiles(localPath);
                output.writeInt(childFiles.size());
                for (File child : childFiles) {
                    this.writeFile(localPath, child, output);
                }
            }
        }

        private List<File> getChildFiles(File base) {
            ArrayList<File> childFiles = new ArrayList<File>();
            this.getChildFiles(base, childFiles);
            return childFiles;
        }

        private void getChildFiles(File base, List<File> childFiles) {
            for (File child : base.listFiles()) {
                if (child.isFile()) {
                    childFiles.add(child);
                    continue;
                }
                this.getChildFiles(child, childFiles);
            }
        }

        private String getRelativePath(File parent, File child) {
            return child.getAbsolutePath().substring(parent.getAbsolutePath().length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File localPath, File file, FlushableDataOutput output) throws IOException {
            output.writeByte(48);
            output.writeByte(37);
            output.writeUTF(this.getRelativePath(localPath, file));
            output.writeByte(49);
            output.writeLong(file.length());
            FileInputStream inputStream = null;
            try {
                int len;
                inputStream = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ignored) {}
                }
            }
            output.writeByte(50);
            output.flush();
        }
    }

    private class UnregisterOperation
    extends AbstractHostRequestHandler {
        private UnregisterOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleRequest(String hostId, DataInput input, ManagementRequestContext<Void> context) throws IOException {
            MasterDomainControllerOperationHandlerImpl.this.domainController.unregisterRemoteHost(hostId);
            FlushableDataOutput os = this.writeGenericResponseHeader(context);
            try {
                os.write(36);
                os.close();
            }
            finally {
                StreamUtils.safeClose((Closeable)os);
            }
        }
    }

    private class RegisterOperation
    extends AbstractHostRequestHandler {
        String error;

        private RegisterOperation() {
        }

        @Override
        void handleRequest(final String hostId, DataInput input, ManagementRequestContext<Void> context) throws IOException {
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    try {
                        final Channel mgmtChannel = context.getChannel();
                        MasterDomainControllerOperationHandlerImpl.this.registry.registerChannel(hostId, mgmtChannel, new UnregisteredHostChannelRegistry.ProxyCreatedCallback(){

                            @Override
                            public void proxyCreated(final ManagementMessageHandler handler) {
                                MasterDomainControllerOperationHandlerImpl.this.proxyHandler = handler;
                                mgmtChannel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                                    public void handleClose(Channel closed, IOException exception) {
                                        handler.shutdownNow();
                                    }
                                });
                            }
                        });
                        ModelNode op = new ModelNode();
                        op.get("operation").set("read-master-domain-model");
                        op.get("address").setEmptyList();
                        op.get("host").set(hostId);
                        ModelNode result = MasterDomainControllerOperationHandlerImpl.this.controller.execute(op, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, null);
                        if (result.hasDefined("failure-description")) {
                            RegisterOperation.this.error = SlaveRegistrationException.forUnknownError(result.get("failure-description").asString()).marshal();
                        }
                    }
                    catch (SlaveRegistrationException e) {
                        RegisterOperation.this.error = e.marshal();
                    }
                    catch (Exception e) {
                        RegisterOperation.this.error = SlaveRegistrationException.forUnknownError(e.getMessage()).marshal();
                    }
                    FlushableDataOutput output = RegisterOperation.this.writeGenericResponseHeader(context);
                    try {
                        if (RegisterOperation.this.error != null) {
                            output.write(34);
                            output.writeUTF(RegisterOperation.this.error);
                        } else {
                            output.write(33);
                        }
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
        }
    }
}

