/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.descriptions.DomainRootDescription;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;

public class DeploymentRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    private static final String DEPLOYMENT_HASHES = "DEPLOYMENT_HASHES";
    private final ContentRepository contentRepository;

    public DeploymentRemoveHandler() {
        this(null);
    }

    public DeploymentRemoveHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.checkCanRemove(context, operation);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        List deploymentHashes = DeploymentUtils.getDeploymentHash((Resource)resource);
        operation.get(new String[]{"operation-headers", DEPLOYMENT_HASHES}).setEmptyList();
        for (byte[] hash : deploymentHashes) {
            operation.get(new String[]{"operation-headers", DEPLOYMENT_HASHES}).add(hash);
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (context.completeStep() != OperationContext.ResultAction.ROLLBACK) {
                    for (ModelNode node : operation.get(new String[]{"operation-headers", DeploymentRemoveHandler.DEPLOYMENT_HASHES}).asList()) {
                        try {
                            DeploymentRemoveHandler.this.contentRepository.removeContent(node.asBytes());
                        }
                        catch (Exception e) {
                            DomainControllerLogger.DEPLOYMENT_LOGGER.debugf(e, "Exception occurred removing %s", node.asBytes());
                        }
                    }
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void checkCanRemove(OperationContext context, ModelNode operation) throws OperationFailedException {
        String deploymentName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        Resource root = context.getRootResource();
        if (root.hasChild(PathElement.pathElement((String)"server-group"))) {
            ArrayList<String> badGroups = new ArrayList<String>();
            for (Resource.ResourceEntry entry : root.getChildren("server-group")) {
                if (!entry.hasChild(PathElement.pathElement((String)"deployment", (String)deploymentName))) continue;
                badGroups.add(entry.getName());
            }
            if (badGroups.size() > 0) {
                throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.cannotRemoveDeploymentInUse(deploymentName, badGroups)));
            }
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return DomainRootDescription.getDeploymentRemoveOperation(locale);
    }
}

