/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;

public class ServerGroupDeploymentAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private final HostFileRepository fileRepository;

    static final ModelNode getOperation(ModelNode address, ModelNode state) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("runtime-name").set(state.get("runtime-name"));
        op.get("hash").set(state.get("hash"));
        op.get("enabled").set(state.get("enabled"));
        return op;
    }

    public ServerGroupDeploymentAddHandler(HostFileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getAddDeploymentOperation((Locale)locale, (boolean)true);
    }

    public void execute(OperationContext context, ModelNode operation) {
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        Resource deploymentResource = context.getRootResource().navigate(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        ModelNode deployment = deploymentResource.getModel();
        for (ModelNode content : deployment.require("content").asList()) {
            if (!content.hasDefined("hash")) continue;
            byte[] hash = content.require("hash").asBytes();
            this.fileRepository.getDeploymentFiles(hash);
        }
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : deployment.get("runtime-name").asString();
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        subModel.get("name").set(name);
        subModel.get("runtime-name").set(runtimeName);
        subModel.get("enabled").set(operation.has("enabled") && operation.get("enabled").asBoolean());
        context.completeStep();
    }
}

