/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.security.sasl.SaslException;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.remote.ExistingChannelModelControllerClient;
import org.jboss.as.controller.remote.TransactionalModelControllerOperationHandler;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.ReconnectPolicy;
import org.jboss.as.host.controller.RemoteDomainConnection;
import org.jboss.as.host.controller.mgmt.DomainRemoteFileRequestAndHandler;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.version.ProductConfig;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossThreadFactory;

public class RemoteDomainConnectionService
implements MasterDomainControllerClient,
Service<MasterDomainControllerClient> {
    private static final ModelNode APPLY_DOMAIN_MODEL = new ModelNode();
    private final ModelController controller;
    private final ProductConfig productConfig;
    private final LocalHostControllerInfo localHostInfo;
    private final RemoteFileRepository remoteFileRepository;
    private volatile ModelControllerClient masterProxy;
    private final FutureClient futureClient = new FutureClient();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmInjector = new InjectedValue();
    private final ThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("domain-connection-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
    private final ExecutorService executor = Executors.newCachedThreadPool(this.threadFactory);
    private RemoteDomainConnection connection;
    private ManagementChannelHandler handler;
    private RemoteFileRepositoryExecutor remoteFileRepositoryExecutor = new RemoteFileRepositoryExecutor(){

        @Override
        public File getFile(String relativePath, byte repoId, HostFileRepository localFileRepository) {
            try {
                return (File)RemoteDomainConnectionService.this.handler.executeRequest((ManagementRequest)new GetFileRequest(repoId, relativePath, localFileRepository), null).getResult().get();
            }
            catch (Exception e) {
                throw HostControllerMessages.MESSAGES.failedToGetFileFromRemoteRepository(e);
            }
        }
    };

    private RemoteDomainConnectionService(ModelController controller, LocalHostControllerInfo localHostControllerInfo, ProductConfig productConfig, RemoteFileRepository remoteFileRepository) {
        this.controller = controller;
        this.productConfig = productConfig;
        this.localHostInfo = localHostControllerInfo;
        this.remoteFileRepository = remoteFileRepository;
        remoteFileRepository.setRemoteFileRepositoryExecutor(this.remoteFileRepositoryExecutor);
    }

    public static Future<MasterDomainControllerClient> install(ServiceTarget serviceTarget, ModelController controller, LocalHostControllerInfo localHostControllerInfo, ProductConfig productConfig, String securityRealm, RemoteFileRepository remoteFileRepository) {
        RemoteDomainConnectionService service = new RemoteDomainConnectionService(controller, localHostControllerInfo, productConfig, remoteFileRepository);
        ServiceBuilder builder = serviceTarget.addService(MasterDomainControllerClient.SERVICE_NAME, (Service)service).addDependency(ManagementRemotingServices.MANAGEMENT_ENDPOINT, Endpoint.class, service.endpointInjector).setInitialMode(ServiceController.Mode.ACTIVE);
        if (securityRealm != null) {
            ServiceName realmName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm});
            builder.addDependency(realmName, SecurityRealm.class, service.securityRealmInjector);
        }
        builder.install();
        return service.futureClient;
    }

    @Override
    public synchronized void register() throws IOException {
        boolean connected = false;
        long timeout = 30000L;
        long endTime = System.currentTimeMillis() + 30000L;
        int retries = 0;
        while (!connected) {
            RemoteDomainConnection.RegistrationResult result = null;
            try {
                result = this.connection.connect();
                connected = true;
            }
            catch (IOException e) {
                Throwable cause = e;
                while ((cause = cause.getCause()) != null) {
                    if (!(cause instanceof SaslException)) continue;
                    throw HostControllerMessages.MESSAGES.authenticationFailureUnableToConnect(cause);
                }
                if (System.currentTimeMillis() > endTime) {
                    throw HostControllerMessages.MESSAGES.connectionToMasterTimeout(e, retries, 30000L);
                }
                try {
                    HostControllerLogger.ROOT_LOGGER.cannotConnect(this.localHostInfo.getRemoteDomainControllerHost(), this.localHostInfo.getRemoteDomainControllertPort());
                    ReconnectPolicy.CONNECT.wait(retries);
                }
                catch (InterruptedException ie) {
                    throw HostControllerMessages.MESSAGES.connectionToMasterInterrupted();
                }
            }
            if (result == null || result.isOK()) continue;
            switch (result.getCode()) {
                case HOST_ALREADY_EXISTS: {
                    throw new HostAlreadyExistsException(result.getMessage());
                }
            }
            throw new IOException(new SlaveRegistrationException(result.getCode(), result.getMessage()).marshal());
        }
        if (connected) {
            this.handler.addHandlerFactory((ManagementRequestHandlerFactory)new TransactionalModelControllerOperationHandler(this.controller, (ManagementChannelAssociation)this.handler));
            this.masterProxy = ExistingChannelModelControllerClient.createAndAdd((ManagementChannelHandler)this.handler);
        }
    }

    @Override
    public synchronized void unregister() {
        StreamUtils.safeClose((Closeable)((Object)this.connection));
    }

    @Override
    public synchronized HostFileRepository getRemoteFileRepository() {
        return this.remoteFileRepository;
    }

    public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(Operation operation) throws IOException {
        return this.masterProxy.execute(operation, OperationMessageHandler.logging);
    }

    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        return this.masterProxy.execute(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        return this.masterProxy.executeAsync(operation, messageHandler);
    }

    public void close() throws IOException {
        throw HostControllerMessages.MESSAGES.closeShouldBeManagedByService();
    }

    public synchronized void start(StartContext context) throws StartException {
        ManagementChannelHandler handler;
        RemoteDomainConnection connection;
        try {
            ModelNode hostInfo = RemoteDomainConnectionService.createLocalHostHostInfo(this.localHostInfo, this.productConfig);
            ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
            configuration.setUri(new URI("remote://" + NetworkUtils.formatPossibleIpv6Address((String)this.localHostInfo.getRemoteDomainControllerHost()) + ":" + this.localHostInfo.getRemoteDomainControllertPort()));
            configuration.setEndpoint((Endpoint)this.endpointInjector.getValue());
            SecurityRealm realm = (SecurityRealm)this.securityRealmInjector.getOptionalValue();
            connection = new RemoteDomainConnection(this.localHostInfo.getLocalHostName(), hostInfo, configuration, realm, this.executor, new RemoteDomainConnection.HostRegistrationCallback(){

                @Override
                public boolean applyDomainModel(List<ModelNode> bootOperations) {
                    return RemoteDomainConnectionService.this.applyRemoteDomainModel(bootOperations);
                }

                @Override
                public void registrationComplete(ManagementChannelHandler handler) {
                }
            });
            handler = connection.getHandler();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        finally {
            this.futureClient.setClient(this);
        }
        this.connection = connection;
        this.handler = handler;
    }

    private boolean applyRemoteDomainModel(List<ModelNode> bootOperations) {
        ModelNode result;
        try {
            ModelNode operation = APPLY_DOMAIN_MODEL.clone();
            operation.get("domain-model").set(bootOperations);
            result = this.controller.execute(operation, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, OperationAttachments.EMPTY);
        }
        catch (Exception e) {
            return false;
        }
        return "success".equals(result.get("outcome").asString());
    }

    public synchronized void stop(StopContext context) {
        StreamUtils.safeClose((Closeable)((Object)this.connection));
    }

    public synchronized MasterDomainControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    static ModelNode createLocalHostHostInfo(LocalHostControllerInfo hostInfo, ProductConfig productConfig) {
        ModelNode info = new ModelNode();
        info.get("name").set(hostInfo.getLocalHostName());
        info.get("release-version").set(Version.AS_VERSION);
        info.get("release-codename").set(Version.AS_RELEASE_CODENAME);
        info.get("management-major-version").set(1);
        info.get("management-minor-version").set(0);
        String productName = productConfig.getProductName();
        String productVersion = productConfig.getProductVersion();
        if (productName != null) {
            info.get("product-name").set(productName);
        }
        if (productVersion != null) {
            info.get("product-version").set(productVersion);
        }
        return info;
    }

    static {
        APPLY_DOMAIN_MODEL.get("operation").set("apply-remote-domain-model");
        APPLY_DOMAIN_MODEL.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        APPLY_DOMAIN_MODEL.get("address").setEmptyList();
        APPLY_DOMAIN_MODEL.protect();
    }

    private static class HostAlreadyExistsException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public HostAlreadyExistsException(String msg) {
            super(msg);
        }
    }

    private class FutureClient
    extends AsyncFutureTask<MasterDomainControllerClient> {
        protected FutureClient() {
            super(null);
        }

        private void setClient(MasterDomainControllerClient client) {
            super.setResult((Object)client);
        }
    }

    private static interface RemoteFileRepositoryExecutor {
        public File getFile(String var1, byte var2, HostFileRepository var3);
    }

    static class RemoteFileRepository
    implements HostFileRepository {
        private final HostFileRepository localFileRepository;
        private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

        RemoteFileRepository(HostFileRepository localFileRepository) {
            this.localFileRepository = localFileRepository;
        }

        public final File getFile(String relativePath) {
            return this.getFile(relativePath, (byte)38);
        }

        public final File getConfigurationFile(String relativePath) {
            return this.getFile(relativePath, (byte)39);
        }

        public final File[] getDeploymentFiles(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40).listFiles();
        }

        public File getDeploymentRoot(byte[] deploymentHash) {
            String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
            return this.getFile(hex, (byte)40);
        }

        private File getFile(String relativePath, byte repoId) {
            return this.remoteFileRepositoryExecutor.getFile(relativePath, repoId, this.localFileRepository);
        }

        private void setRemoteFileRepositoryExecutor(RemoteFileRepositoryExecutor remoteFileRepositoryExecutor) {
            this.remoteFileRepositoryExecutor = remoteFileRepositoryExecutor;
        }

        public void deleteDeployment(byte[] deploymentHash) {
            this.localFileRepository.deleteDeployment(deploymentHash);
        }
    }

    private class GetFileRequest
    extends AbstractManagementRequest<File, Void> {
        private final byte rootId;
        private final String filePath;
        private final HostFileRepository localFileRepository;

        private GetFileRequest(byte rootId, String filePath, HostFileRepository localFileRepository) {
            this.rootId = rootId;
            this.filePath = filePath;
            this.localFileRepository = localFileRepository;
        }

        public byte getOperationType() {
            return 85;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnectionService.this.localHostInfo.getLocalHostName());
            DomainRemoteFileRequestAndHandler.INSTANCE.sendRequest(output, this.rootId, this.filePath);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            File localPath;
            switch (this.rootId) {
                case 38: {
                    localPath = this.localFileRepository.getFile(this.filePath);
                    break;
                }
                case 39: {
                    localPath = this.localFileRepository.getConfigurationFile(this.filePath);
                    break;
                }
                case 40: {
                    byte[] hash = HashUtil.hexStringToByteArray((String)this.filePath);
                    localPath = this.localFileRepository.getDeploymentRoot(hash);
                    break;
                }
                default: {
                    localPath = null;
                }
            }
            try {
                DomainRemoteFileRequestAndHandler.INSTANCE.handleResponse(input, localPath, HostControllerLogger.ROOT_LOGGER, resultHandler, context);
            }
            catch (RemoteFileRequestAndHandler.CannotCreateLocalDirectoryException e) {
                throw HostControllerMessages.MESSAGES.cannotCreateLocalDirectory(e.getDir());
            }
            catch (RemoteFileRequestAndHandler.DidNotReadEntireFileException e) {
                throw HostControllerMessages.MESSAGES.didNotReadEntireFile(e.getMissing());
            }
        }
    }
}

