/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandler;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerImpl;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;

public class MasterDomainControllerOperationHandlerService
extends AbstractModelControllerOperationHandlerFactoryService {
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
    private final DomainController domainController;

    public MasterDomainControllerOperationHandlerService(DomainController domainController) {
        this.domainController = domainController;
    }

    public HandleableCloseable.Key startReceiving(Channel channel) {
        final ManagementChannelHandler handler = new ManagementChannelHandler(ManagementClientChannelStrategy.create((Channel)channel), this.getExecutor());
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new HostControllerRegistrationHandler(handler, this.getController(), this.domainController));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new ModelControllerClientOperationHandler(this.getController(), (ManagementChannelAssociation)handler));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new MasterDomainControllerOperationHandlerImpl(this.domainController));
        HandleableCloseable.Key key = channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleClose(Channel closed, IOException exception) {
                handler.shutdown();
                try {
                    handler.awaitCompletion(100L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    HostControllerLogger.ROOT_LOGGER.serviceShutdownIncomplete(e);
                }
                finally {
                    handler.shutdownNow();
                }
            }
        });
        channel.receiveMessage(handler.getReceiver());
        return key;
    }
}

